<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:ya="urn:yandex-functions"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" x ya exsl"
    exclude-result-prefixes=" x lego ya exsl "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search//lego:input/lego:keyboard-for-foreigner">
    <xsl:variable name="foreign">
        <!-- Россия -->
        <x:geo-block xpointer="/result/@code[. = '0']">
            <x:method>isIn</x:method>
            <x:param type="String">225</x:param>
        </x:geo-block>
        <!-- Украина -->
        <x:geo-block xpointer="/result/@code[. = '0']">
            <x:method>isIn</x:method>
            <x:param type="String">187</x:param>
        </x:geo-block>
        <!-- Беларусь -->
        <x:geo-block xpointer="/result/@code[. = '0']">
            <x:method>isIn</x:method>
            <x:param type="String">149</x:param>
        </x:geo-block>
    </xsl:variable>
    <!-- TODO : после внедрения клавиатуры убрать реакцию на параметр search-keyboard -->
    <xsl:if test="$foreign != '0' or x:get-query-arg('keyboard-for-foreigner') = 'force' or x:get-query-arg('search-keyboard') = 'yes'">
        <xsl:call-template name="lego:apply">
            <xsl:with-param name="content">
                <lego:b-keyboard-loader lego:type="search" lego:lang="ru">русская клавиатура<lego:flag/></lego:b-keyboard-loader>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:if>
</xsl:template>

</xsl:stylesheet>
