<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

    <xsl:template match="lego:b-serp-item//lego:title">
        <h3>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </h3>
    </xsl:template>

    <xsl:template match="lego:b-serp-item//lego:title" mode = "lego:content">
        <a class = "b-serp-item__title-link">
            <xsl:attribute name="target">
                <xsl:apply-templates select="." mode="lego:target"/>
            </xsl:attribute>
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:apply-templates mode="lego:copy"/>
        </a>
    </xsl:template>

    <xsl:template match="lego:b-serp-item//lego:title" mode="lego:target">
        <xsl:text>_blank</xsl:text>
    </xsl:template>

    <xsl:template match="lego:b-serp-item//lego:title[@target]" mode="lego:target">
        <xsl:value-of select="@target"/>
    </xsl:template>

</xsl:stylesheet>
