<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-serp-sitelinks">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-serp-sitelinks/lego:sitelinks-link">
    <a>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

<xsl:template match="lego:b-serp-sitelinks[@type='rows']">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <table cellpadding = "0" cellspacing = "0">
        <tr>
            <xsl:apply-templates select="." mode="lego:content"/>
        </tr>
        </table>
    </div>
</xsl:template>

<xsl:template match="lego:b-serp-sitelinks[@type='rows']/lego:sitelinks-cell">
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </td>
</xsl:template>

<xsl:template match="lego:b-serp-sitelinks[@type='rows']/lego:sitelinks-cell/lego:sitelinks-link">
    <a>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
    <xsl:if test = "last()">
        <br />
    </xsl:if>
</xsl:template>

</xsl:stylesheet>
