<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-serp-url">
    <xsl:variable name = "display">
        <xsl:choose>
            <xsl:when test = "@lego:inline = 'yes'">span</xsl:when>
            <xsl:otherwise>div</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:element name = "{$display}">
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </xsl:element>
</xsl:template>

<xsl:template match="lego:b-serp-url" mode="lego:content">
    <xsl:apply-templates select = "lego:text | lego:link"/>
</xsl:template>

<xsl:template match = "lego:b-serp-url/lego:text | lego:b-serp-url/lego:link">
    <span class = "b-serp-url__item">
        <xsl:apply-templates select="." mode="lego:item-content"/>
    </span><xsl:text> </xsl:text>
</xsl:template>

<xsl:template match = "lego:b-serp-url[@lego:type = 'middot']/lego:text | lego:b-serp-url[@lego:type = 'middot']/lego:link">
    <xsl:if test="position() - 1">&#160;&#183; </xsl:if>
    <xsl:apply-templates select = "." mode = "lego:item-content"/>
</xsl:template>

<xsl:template match = "lego:b-serp-url/lego:text" mode="lego:item-content">
    <xsl:value-of select = "." />
</xsl:template>

<xsl:template match = "lego:b-serp-url/lego:link" mode="lego:item-content">
    <a>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

<xsl:template match = "lego:b-serp-url/lego:link[@lego:type = 'phone']" mode="lego:item-content">
    <a>
        <xsl:apply-templates select="." mode="lego:block-attributes" />
        <xsl:apply-templates select="." mode="lego:url" />
        <img src = "//img.yandex.net/i/search/phone.gif" class = "b-serp-url__link-icon" />&#160;
        <span class = "b-serp-url__link-text">
            <xsl:apply-templates select="." mode="lego:content" />
        </span>
    </a>
</xsl:template>

</xsl:stylesheet>
