/**
 * Создаёт пример блока, основываясь на файлах
 */

var fs = require('fs'),
    exec = require('child_process').exec,
    path = require('path'),
    lego = new (require('../../../tools/lego').Lego)(process.argv[2]),
    util = require('../../../tools/util');

/** {Number} счетчик примеров */
var counter = 0,
    /** {Number} величина отбивки по-умолчанию */
    padSize = 2;

var oldExamples = [],
    examplesPath = 'blocks/b-service-icon/examples/';

function generateModXml(m, cb) {
    var xml = '<?xml version="1.0" encoding="utf-8"?>\n' +
        '<!-- Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. -->\n' +
        '<lego:page ' +
        'xmlns:lego="https://lego.yandex-team.ru" ' +
        'xmlns:xhtml="http://www.w3.org/1999/xhtml"' +
        '>';
    xml += '<lego:b-menu lego:layout="vert">';
    util.Step(
        function () {
            var _this = this;
            m.vals.map(function(val) {
                generateModValXml(m, val, _this.parallel());
            });
        },
        function (err) {
            xml += Array.prototype.slice.call(arguments, 1).join('');
            xml += '</lego:b-menu>';
            xml += '</lego:page>';

            var cleanName = 'b-service-icon_' + m.name + '_xml';

            var examples = exampleExists(cleanName);
            if( examples.length ) {
                removeExamples( examples );
            }

            counter += 10;
            var prefix = util.lpad(counter, padSize, '0') + '_auto-';

            exampleFileName = examplesPath + prefix + cleanName;

            util.writeFile(exampleFileName + '.title.txt', m.title);
            util.writeFile(exampleFileName + '.xml', xml);
            exec('xmlindent -w -i 4 ' + exampleFileName + '.xml', function (err, stdout, stderr) {
                if (err) return cb(err);
                cb(null);
            });
        }
    );
}

function generateModValXml(m, val, cb) {
    var filePath = 'blocks/b-service-icon/_' + m.name + '/b-service-icon_' + m.name + '_' + val.name;
    if (path.existsSync(filePath + '.png')) {
        filePath += '.png';
    } else if (path.existsSync(filePath + '.ico')) {
        filePath += '.ico';
    } else if (path.existsSync(filePath + '.svg')) {
        filePath += '.svg';
    }

    util.sha1sum(filePath, function (err, sha1) {
        if (err) return cb(err);
        var freeze_name = util.fixSha1Base64(sha1),
            freeze_url = '//yastatic.net/lego/_/' + freeze_name + '.' + filePath.split('.')[filePath.split('.').length - 1],
            xml = '<lego:item>' +
                    (/svg/.test(m.name) ? '<xhtml:object type="image/svg+xml" data="' + freeze_url + '" height="100" width="100"></xhtml:object>' : '<lego:b-ico src="' + freeze_url + '" alt="' + val.title + '"/>') +
                    '<lego:text> <xhtml:strong>' + val.title + '</xhtml:strong></lego:text>' +
                '</lego:item>' +
                '<lego:item>' +
                    '<lego:text>' +
                        '<xhtml:strong>url:</xhtml:strong> ' + freeze_url +
                    '</lego:text>' +
                '</lego:item>';

        cb(null, xml);
    });
};

function generateExampleXml(lego, cb) {
    var mods = lego.getModsFromFileSys('b-service-icon');

    // Уже существующие файлы примеров
    oldExamples = lego.getFiles('blocks/b-service-icon/examples/')
        .filter(function(s) {
            return (/_xml\.xml$/.test(s));
        });

    padSize = (mods.length + '').length + 1;

    util.Step(
        function () {
            var _this = this;
            mods.map(function (m) {
                generateModXml(m, _this.parallel());
            });
        },
        function (err) {
            if (err) return cb(err);
            cb(null);
        }
    );
}

function exampleExists(exampleCleanName) {
    var reName = new RegExp('^\\d+_auto\\-' + exampleCleanName + '\\.xml$');
    return util.arrayUnique(
        oldExamples.filter(function(s){
            return reName.test(s);
        })
        .map(function(n){ return n.replace(/\..*$/, ''); })
    );
}

function removeExamples(examples) {
    examples.map(function(s) {
        try {
            fs.unlinkSync(examplesPath + s + '.title.txt');
            fs.unlinkSync(examplesPath + s + '.xml');
        } catch (e) {
            return false;
        }
    });
}

generateExampleXml(lego, function (err) {
    if (err) throw err;
});
