BEM.DOM.decl('b-smart-help', {

    onSetMod : {

        'loading' : {

            'completed' : function() {

                BEM.blocks['i-update-session'].start();

                var _this = this;
                _this._dataprovider = BEM.create('b-smart-help__dataprovider', {
                    data : { sid : Math.round(Math.random() * +new Date) },
                    url : _this.params.apiUrl,
                    callbackCtx : _this,
                    retryCount : 3 });

                $.each(['_stats', '_readMoreCounter'], function(i, key) {
                    _this[key] = BEM.create('i-statface', {
                        pid : 0,
                        cid : 70592,
                        keys : ['prj', 'root', 'typing', 'article', 'action']
                    });
                });

                this.afterCurrentEvent(_this._getLayout);

            }

        },

        'visibility' :  {

            'visible' : function() {

                var _this = this.delMod('send-state');
                this._searchInput.on({
                    'change' : $.debounce(this._onSearchChange, 200, this),
                    'focus' : function() {
                        _this.delMod(_this.elem('content'), 'visibility');
                    }})
                    .val('');
                this.elem('placeholder').hide().slideDown(function() {
                    _this._scrollToView(function() {
                        _this._searchInput
                            .delMod('disabled')
                            .setMod('focused', 'yes');
                    });
                });
                this._stats
                    .set('prj', this.params.fromPrj)
                    .set('root', 'main')
                    .set('typing', 'not-typing')
                    .set('article', 'not-open-article');

            },

            '' : function() {

                this._searchInput.un();
                this.elem('placeholder').slideUp();
                this
                    .delMod(this.elem('content'), 'visibility')
                    ._dataprovider.preventCallbacks();
                this._stats.send();

            }

        },

        'send-state' : {

            'can' : function() {

                this._stats.set('typing', 'typing');

            },

            'can-progress' : function() {

                this
                    .delMod(this.elem('content'), 'visibility')
                    ._dataprovider.get(
                        { action : 'email', key : Lego.params.yandexuid },
                        this._onGetEmail,
                        this._onGetEmailError);
                this._searchInput.un();

            },

            'wish' : function() {

                this._searchInput.delMod('disabled');
                this._emailInput
                    .on('change', function() {
                        this.delMod(this.elem('message'), 'visibility');
                    })
                    .delMod('disabled');
                this.elem('action', 'type', 'wish-send').attr('disabled', false);
                this
                    .bindTo(this.elem('form'), 'submit', function(e) {
                        e.preventDefault();
                        this.setMod('send-state', 'wish-progress');
                    })
                    .afterCurrentEvent(function() {
                        this._emailInput.val()?
                            this.elem('action', 'type', 'wish-send').focus() :
                            this._emailInput.setMod('focused', 'yes');
                    });

            },

            'wish-progress' : function() {

                this._emailInput
                    .un()
                    .setMod('disabled', 'yes');
                this._searchInput.setMod('disabled', 'yes');
                this
                    .unbindFrom(this.elem('form'), 'submit')
                    .elem('action', 'type', 'wish-send').attr('disabled', true);
                var _this = this,
                    data = $.extend({
                            action : 'send',
                            from : this.params.fromPrj,
                            email : this._emailInput.val(),
                            key : Lego.params.yandexuid
                        }, this._buildMessage());
                this.elem('meta-info').find('input').each(function() {
                    data[this.name] = this.value;
                });

                this._dataprovider.get(
                    data,
                    this._onSend,
                    this._onSendError,
                    { cache : false });

            },

            'finish' : function() {

                var _this = this;
                setTimeout(function() {
                    _this.delMod('visibility');
                }, 2000);
                _this._stats.set('action', 'send');

            }

        }

    },

    onElemSetMod : {

        'content' : {

            'visibility' : {

                'visible' : function() {

                    var args = arguments;
                    this
                        .bindToWin(
                            'resize',
                            $.debounce(this._animateContentFn = function() {
                                this.hasMod.apply(this, args) && this._animateContent({});
                            }, 500, this))
                        ._stats.set('article', 'open-article');

                },

                '' : function(elem) {

                    this
                        .unbindFromWin('resize', this._animateContentFn)
                        .delMod(elem, 'with-sections')
                        ._animateContent({ data : false, sections : false })
                        .del('_contentId', '_menuId', '_sectionsLinks', '_sectionsMenu');

                }

            },

            'with-sections' : {

                'yes' : function() {

                    this._setCurrentSection();
                    this._sectionsMenu.on('trigger', function() { this._animateContent({}) }, this);
                },

                '' : function() {

                    this._sectionsMenu && this._sectionsMenu.un('trigger current');

                }

            }

        }

    },

    _getLayout : function() {

        this._dataprovider.get(
            {
                action : 'top',
                'prj-id' : this.params.prjId,
                'from-prj' : this.params.fromPrj
            },
            this._onGetLayout,
            this._onError);

    },

    _onGetLayout : function(data) {

        BEM.DOM.init(this.delMod(this.elem('action', 'type', 'open'), 'loading').elem('placeholder').html(data.layout), function() {
            this._searchInput = this.findBlockInside(this.elem('placeholder'), 'b-form-input');
            BEM.DOM.init(this.elem('search-results').html(data.questions));
            BEM.blocks['b-menu'].liveCtxBind(
                this.elem('placeholder'),
                'current',
                this._onMenuCurrent,
                this);
            this.setMod('visibility', 'visible');
        }, this);

    },

    _onActionClick : function(domElem) {

        switch(this.getMod(
            domElem.closest(this.buildSelector('action')),
            'type')) {

            case 'open':
                this.hasMod('loading', 'completed')?
                    this.toggleMod('visibility', 'visible') :
                    this.__base(domElem);
                break;

            case 'close':
            case 'thnx-close':
                this._stats.set('action', 'close');
                this.delMod('visibility');
                break;

            case 'hide-content':
                this.delMod(this.elem('content'), 'visibility');
                break;

            case 'up-content':
                this._scrollTo(this.elem('placeholder').offset().top);
                break;

            case 'toggle-sections':
                this
                    .toggleMod(this.elem('content'), 'with-sections', 'yes')
                    ._animateContent({ sections : this.hasMod(this.elem('content'), 'with-sections', 'yes') });
                break;

            case 'can-send':
                this.setMod('send-state', 'can-progress');
                break;

            case 'wish-send':
                this.setMod('send-state', 'wish-progress');
                break;

            case 'read-more':
                this._readMoreCounter
                    .set('prj', this.params.fromPrj)
                    .set('root', 'read-more')
                    .send();
                break;

        }

    },

    _onMenuCurrent : function(e, data) {

        this._onClick(e.block.findElem(data.current, 'item-selector'));

    },

    _onClick : function(domElem) {

        this._getArticle(this._extractIds(domElem));

    },

    _scrollToView : function(callback) {

        var placeholder = this.elem('placeholder'),
            scrollVal = placeholder.offset().top +
                placeholder.height() -
                this._getWindowHeight() -
                this.__self.doc.scrollTop();
        scrollVal > 0?
            this._scrollTo('+=' + scrollVal, callback) :
            callback();

    },

    _setCurrentSection : function() {

        var _this = this,
            menu = _this._sectionsMenu = _this.findBlockInside(_this.elem('sections'), 'b-menu');
        if(!_this._sectionsLinks) {
            _this._sectionsLinks = {};
            menu.elem('item-selector').each(function() {
                _this._sectionsLinks[_this._extractIds($(this))['content-id']] = $(this);
            });
        }
        var link = _this._sectionsLinks[_this._contentId];
        link?
            menu.setMod(
                link.closest(menu.buildSelector('item')),
                'state',
                'current') :
            menu.delMod(menu.elem('item', 'state', 'current'), 'state');

    },

    _animateContent : function(props) {

        var hasSections = this.hasMod(this.elem('content'), 'with-sections', 'yes'),
            animateProps = {'content-left' : {}, 'content-right' : {}, 'content' : {}},
            contentLeftSelfHeight = props.sections === false || !hasSections? 0 : this.elem('content-left-i').height(),
            contentLeftHeight = this.elem('content-left').height(),
            contentRightSelfHeight = props.data === false? 0 : this.elem('content-right-i').height(),
            contentRightHeight = this.elem('content-right').height();

        typeof props.sections != 'undefined' && (animateProps['content-left'].left = props.sections? '-30%' : '100%');
        typeof props.data != 'undefined' && (animateProps['content'].left = props.data? '34%' : '100%');

        var contentHeight = Math.max(contentLeftSelfHeight, contentRightSelfHeight);

        (props.sections || hasSections) && contentHeight != contentLeftHeight &&
            (animateProps['content-left'].height = contentHeight);

        contentHeight != contentRightHeight &&
            (animateProps['content-right'].height = contentHeight);

        this.elem('content content-left content-right body').stop(true);

        var _this = this;
        $.each(animateProps, function(name) {
            $.isEmptyObject(this) || _this.elem(name).animate(this);
        });

        this.elem('body').animate(
            {
                height : props.data === false?
                    this.elem('body-i').height() :
                    Math.max(contentHeight, this.elem('body-i').height())
            },
            function() {
                props.data === false && _this.elem('body').css('height', 'auto');
                _this._ieReflow();
            });

        return this;

    },

    _onSearchChange : function() {

        var val = this._searchInput.val();
        this
            .toggleMod('send-state', 'can', !!val)
            ._dataprovider.get(
                { action : 'search', search : val, 'prj-id' : this.params.prjId },
                function(data) {
                    if(data.questions) {
                        !data.article && this.delMod(this.elem('content'), 'visibility');
                        this._onGetSearchResults(data);
                    } else if(!data.article && !data.layout) {
                        // если вопросы не найдены, возвращаем топ
                        this._dataprovider.get({ action : 'top', 'prj-id' : this.params.prjId }, arguments.callee);
                    }
                    data.article && this._onGetArticle(data);
                },
                this._onGetSearchResultsError);

        return this;

    },

    _onGetSearchResults : function(data) {

        BEM.DOM.update(this.elem('search-results'), data.questions);
        this._ieReflow();

    },

    _onGetSearchResultsError : function() {

        this._showError();

    },

    _extractIds : function(domElem) {

        var params = domElem.attr('href').match(/#(?:(\d+)-)?(\d+)$/);
        return { 'menu-id' : params[1], 'content-id' : params[2] };

    },

    _getArticle : function(ids) {

        if(this._contentId == ids['content-id']) {
            this.hasMod(this.elem('content'), 'visibility', 'visible') || this._showContent();
        } else {
            this
                .setMod(this.elem('content-right'), 'loading', 'yes')
                ._showContent()
                ._contentId = ids['content-id'];

            ids['menu-id'] && this._menuId != ids['menu-id']?
                this
                    .setMod(this.elem('content-left'), 'loading', 'yes')
                    .del('_sectionsLinks', '_sectionsMenu')
                    ._menuId = ids['menu-id'] :
                this.del(ids, 'menu-id');

            this._dataprovider.get(
                $.extend({ action : 'article' }, ids),
                this._onGetArticle,
                this._onGetArticleError);
        }

    },

    _onGetArticle : function(data) {

        this.elem('content-right content-right-i').css('height', 'auto');

        data['content-id'] && (this._contentId = data['content-id']);

        var elems = this.elem('data');
        if(data.sections) {
            elems = elems.add(this.elem('sections'));
            this
                .del('_sectionsLinks', '_sectionsMenu')
                ._menuId = data['menu-id'];
        }

        BEM.DOM.destruct(elems, true);

        this.elem('data').html(data.article);
        data.sections && this.elem('sections').html(data.sections);

        BEM.DOM.init(
            elems,
            function() {
                this.hasMod(this.elem('content'), 'with-sections', 'yes') && this._setCurrentSection();
                this
                    .delMod(this.elem('content-right'), 'loading')
                    .delMod(this.elem('content-left'), 'loading')
                    ._showContent();
            },
            this);

        // выключаем current в меню в результатах поиска
        var searchMenu = this.findBlockInside(this.elem('search-results'), 'b-menu'),
            currentItem = searchMenu.elem('item', 'state', 'current');
        currentItem && searchMenu.delMod(currentItem, 'state');

    },

    _onGetArticleError : function() {

        this
            .delMod(this.elem('content'), 'visibility')
            ._showError();

    },

    _showContent : function() {

        return this
            .setMod(this.elem('content'), 'visibility', 'visible')
            ._animateContent({ data : true })
            .toggleMod(
                this.elem('action', 'type', 'up-content'),
                'visibility',
                'hidden',
                this.elem('content-right-i').height() < this._getWindowHeight());

    },

    _onGetEmail : function(data) {

        this._emailInput? // инициализируем email только один раз
            this.setMod('send-state', 'wish') :
            BEM.DOM.init(this.dropElemCache().elem('form').append(data.email), function() {
                this._emailInput = this.findBlockInside(this.elem('email'), 'b-form-input');
                this.setMod('send-state', 'wish');
            }, this);

    },

    _onGetEmailError : function() {

        this
            .setMod('send-state', 'can')
            ._showError();

    },

    _onSend : function(data) {

        this.setMod('send-state', data.send == 'ok'? 'finish' : 'wish');
        data.send == 'email' &&
            this._emailInput.setMod(this._emailInput.elem('message'), 'visibility', 'visible');

    },

    _onSendError : function() {

        this
            .setMod('send-state', 'wish')
            ._showError();

    },

    _showError : function() {

        var _this = this,
            elem = this.elem('message', 'type', 'error');
        this._errorTimer && clearTimeout(this._errorTimer);
        this._errorTimer = setTimeout(function() {
            _this
                .delMod(elem, 'visibility')
                .del('_errorTimer');
        }, 2000);
        this.setMod(elem, 'visibility', 'visible');

    },

    _scrollTo : function(val, callback) {

        $('html,body').animate({ scrollTop : val }, callback);

    },

    _getWindowHeight : function() {

        return window.innerHeight || document.documentElement.clientHeight;

    },

    _ieReflow : function() {

        (($.browser.msie && $.browser.version < 7) || !$.support.boxModel) && // LEGO-1743 - ИЕ6 игнорирует пересчет высоты скриптом
            (this.elem('placeholder')[0].className += '');

    },

    _buildMessage : function() {

        return {
            subject : this._searchInput.val().substr(0, 50).replace(/\s+\S+$/, ''),
            message : this._searchInput.val() + '\n\n--\n' + document.location
        }

    }

}, {

    live : function() {

        this.__base();
        this.liveBindTo('article', 'click', function(e) {
            this._onClick(e.data.domElem);
        });

    }

});
