<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

    <xsl:template match="lego:b-smart-help//lego:form-question">
        <div>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </div>
    </xsl:template>

    <xsl:template match="lego:b-smart-help//lego:form-question/lego:b-form-input[lego:input/@name='email']">
        <xsl:apply-imports/>
        <xsl:apply-templates select="/" mode="meta-info"/>
    </xsl:template>

    <xsl:template match="lego:b-smart-help//lego:form-question/lego:b-form-input[lego:input/@name='email']/lego:input">
        <xsl:call-template name="lego:box">
            <xsl:with-param name="content">
                <input>
                    <xsl:apply-templates select="." mode="lego:block-attributes"/>
                    <xsl:attribute name="value"><xsl:value-of select="/lego:page/x:root/address-list/address[@is-permanent = 1 and contains(., '@ya.ru')]"/></xsl:attribute>
                </input>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="lego:b-smart-help//lego:form-question/lego:b-form-input[lego:input/@name='email']/lego:samples">
        <xsl:variable name="main-email" select="/lego:page/x:root/address-list/address[@is-permanent = 1 and contains(., '@ya.ru')]"/>
        <xsl:apply-templates select="$main-email | /lego:page/x:root/address-list/address[@is-permanent != 1]"/>
    </xsl:template>

    <xsl:template match="address">
        <xsl:if test="position() - 1">, </xsl:if>
        <span class="b-form-input__sample">
            <span class="b-pseudo-link b-pseudo-link_is-bem_yes i-bem">
                <xsl:attribute name="onClick">return {'b\-pseudo\-link':{name:'b\-pseudo\-link'}}</xsl:attribute>
                <xsl:value-of select="."/>
            </span>
        </span>
    </xsl:template>

    <xsl:template match="/" mode="meta-info">
        <div class="b-static-text b-smart-help__meta-info">
            <input name="X-Address" type="hidden" value="{x:get-protocol-arg('remote_ip')}"/>
            <input name="X-Browser" type="hidden" value="{x:get-header('USER-AGENT')}"/>
            <input name="X-Proxy" type="hidden" value="{x:get-header('X-FORWARDED-FOR')}"/>
            <input name="yandexuid" type="hidden" value="{x:get-cookie('yandexuid')}"/>
            <input name="referer" type="hidden" value="{x:get-header('REFERER')}"/>
            <!--input name="from" type="hidden" value="default"/-->
            <input name="login" type="hidden" value="{x:get-state-arg('auth_login')}"/>
        </div>
    </xsl:template>

    <xsl:template match="lego:b-smart-help//lego:form-question/lego:b-form-input[lego:input/@name='email']/lego:samples">
        <xsl:variable name="main-email"
            select="/lego:page/x:root/address-list/address[@is-permanent = 1 and contains(., '@ya.ru')]"/>
        <xsl:apply-templates select="$main-email | /lego:page/x:root/address-list/address[@is-permanent != 1]"/>
        <xsl:apply-templates select="." mode="meta-info"/>
    </xsl:template>

    <xsl:template match="lego:b-smart-help//lego:form-question/lego:b-form-input[lego:input/@name='fio']/lego:samples">
        <span class="b-form-input__sample">
            <span class="b-pseudo-link b-pseudo-link_is-bem_yes i-bem">
                <xsl:attribute name="onclick">return {'b\-pseudo\-link':{name:'b\-pseudo\-link'}}</xsl:attribute>
                <xsl:value-of select="/lego:page/x:root/user/fio"/>
            </span>
        </span>
    </xsl:template>

    <xsl:template match="lego:b-smart-help//lego:form-question/select[@name='subject']">
        <span class="">
            <label for="idSubject" class="b-form-input__label">Тема сообщения</label>
            <select name="subject" id="idSubject" width="100%" class="b-smart-help__subject">
                <option selected="selected" value="Описание моего сайта содержит ошибку">Описание моего сайта содержит ошибку</option>
                <option value="Регион сайта определен неверно">Регион сайта определен неверно</option>
                <option value="Мой сайт пропал из Каталога">Мой сайт пропал из Каталога</option>
                <option value="Некачественный сайт в Каталоге">Некачественный сайт в Каталоге</option>
                <option value="У меня вопрос про тИЦ">У меня вопрос про тИЦ</option>
                <option value="У меня вопрос по платной регистрации">У меня вопрос по платной регистрации</option>
                <option value="другое">Другое</option>
            </select>
        </span>
    </xsl:template>

</xsl:stylesheet>
