<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:func="http://exslt.org/functions"
    xmlns:xi="http://www.w3.org/2001/XInclude"
    exclude-result-prefixes=" lego xi func "
    extension-element-prefixes=" func "
    version="1.0">

    <xsl:template match="lego:b-smart-help">
        <lego:declaration>
            <xsl:choose>
                <xsl:when test="@lego:loading = 'completed'">
                    <lego:i-jquery>
                        <lego:debounce/>
                    </lego:i-jquery>
                    <lego:i-update-session/>
                    <lego:i-request lego:type="ajax"/>
                    <lego:i-statface/>
                    <lego:b-pseudo-link lego:is-bem="yes"/><!-- NOTE: для перекрытия приоритета при миксах -->
                    <lego:b-smart-help lego:loading="no" lego:visibility="visible" lego:send-state="can">
                        <lego:dataprovider/>
                        <lego:content lego:with-sections="yes"/>
                    </lego:b-smart-help>
                    <lego:b-smart-help lego:send-state="wish"/>
                    <lego:b-smart-help lego:send-state="finish"/>
                    <lego:b-form-input lego:is-bem="yes">
                        <lego:label/>
                        <lego:message lego:type="error"/>
                        <lego:samples/>
                    </lego:b-form-input>
                    <lego:b-menu lego:is-bem="yes" lego:layout="vert" lego:theme="round">
                        <lego:trigger/>
                        <lego:item>
                            <lego:b-pseudo-link lego:type="wrap"/>
                        </lego:item>
                    </lego:b-menu>
                </xsl:when>
                <xsl:otherwise>
                    <lego:i-bem>
                        <lego:dom/>
                    </lego:i-bem>
                    <lego:i-loader/>
                    <lego:b-smart-help lego:loading="no">
                        <lego:loader lego:type="sweet"/>
                        <lego:action lego:type="open" lego:loading="yes"/>
                    </lego:b-smart-help>
                </xsl:otherwise>
            </xsl:choose>
        </lego:declaration>
        <xsl:copy>
            <xsl:attribute name="lego:loading">no</xsl:attribute>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-smart-help/lego:content">
        <lego:action lego:type="close">
            <lego:b-pseudo-link lego:is-bem="yes"><lego:b-ico/>закрыть</lego:b-pseudo-link>
        </lego:action>
        <lego:message lego:type="error">Извините, что-то пошло не&#160;так. Попробуйте позднее.</lego:message>
        <lego:wrap>
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <lego:content-left>
                    <lego:content-left-i>
                        <lego:loader/>
                        <lego:nav>
                            <lego:action lego:type="toggle-sections">
                                <lego:b-pseudo-link lego:is-bem="yes"><lego:b-ico lego:action="hide"/>свернуть&#160;разделы</lego:b-pseudo-link>
                            </lego:action>
                        </lego:nav>
                        <lego:sections/>
                    </lego:content-left-i>
                </lego:content-left>
                <lego:content-right>
                    <lego:content-right-i>
                        <lego:loader/>
                        <lego:nav>
                            <lego:action lego:type="hide-content">
                                <lego:b-pseudo-link lego:is-bem="yes"><lego:b-ico lego:action="hide"/>свернуть</lego:b-pseudo-link>
                            </lego:action>
                            <lego:action lego:type="toggle-sections">
                                <lego:b-pseudo-link lego:is-bem="yes"><lego:b-ico lego:action="show"/>развернуть&#160;разделы</lego:b-pseudo-link>
                            </lego:action>
                        </lego:nav>
                        <lego:data>
                            <lego:b-static-text/>
                        </lego:data>
                        <lego:nav>
                            <lego:action lego:type="up-content" lego:visibility="hidden">
                                <lego:b-pseudo-link lego:is-bem="yes"><lego:b-ico lego:action="up"/>вернуться&#160;наверх</lego:b-pseudo-link>
                            </lego:action>
                        </lego:nav>
                    </lego:content-right-i>
                </lego:content-right>
            </xsl:copy>

            <lego:body>
                <lego:body-i>
                    <lego:layout lego:type="body">
                        <lego:column lego:type="gap-left"><lego:gap/></lego:column>
                        <lego:column lego:type="left">
                            <lego:title>Ваш вопрос</lego:title>
                            <lego:form>
                                <lego:form-question>
                                    <lego:b-form-input lego:is-bem="yes" lego:type="textarea">
                                        <lego:hint>Опишите проблему подробнее</lego:hint>
                                        <lego:input/>
                                    </lego:b-form-input>
                                    <lego:arrow/>
                                </lego:form-question>
                                <lego:email/>
                            </lego:form>
                            <lego:gap/>
                        </lego:column>
                        <lego:column>
                            <lego:inner>
                                <lego:loader>
                                    <lego:declaration>
                                        <lego:b-spin/>
                                    </lego:declaration>
                                </lego:loader>
                                <lego:search-results>
                                    <lego:questions>
                                        <lego:title/>
                                    </lego:questions>
                                    <!--
                                    <lego:services>
                                        <lego:b-menu lego:is-bem="yes" lego:layout="vert">
                                            <lego:title/>
                                            <lego:item>
                                                <lego:b-pseudo-link lego:type="wrap"/>
                                            </lego:item>
                                        </lego:b-menu>
                                    </lego:services>
                                    -->
                                </lego:search-results>
                                <lego:action lego:type="read-more">
                                    <lego:b-link target="_blank" url="http://help.yandex.ru/">Почитать всю помощь</lego:b-link>
                                </lego:action>
                            </lego:inner>
                        </lego:column>
                        <!--<xsl:apply-templates select="lego:reclama"/>-->
                        <lego:column lego:type="gap-right"><lego:gap/></lego:column>
                    </lego:layout>
                </lego:body-i>
            </lego:body>

            <lego:layout lego:type="foot">
                <lego:column lego:type="gap-left"><lego:gap/></lego:column>
                <lego:column lego:type="left">
                    <lego:action lego:type="can-send">
                        <lego:b-pseudo-link lego:is-bem="yes">Отправить запрос в службу поддержки</lego:b-pseudo-link>
                    </lego:action>
                    <lego:action lego:type="wish-send">Отправить</lego:action>
                    <lego:action lego:type="finish-send">Ваш запрос отправлен в службу поддержки</lego:action>
                    <lego:loader-wrap>
                        <lego:loader lego:type="sweet"/>
                    </lego:loader-wrap>
                </lego:column>
                <lego:column>
                    <lego:action lego:type="thnx-close">
                        <lego:b-pseudo-link lego:is-bem="yes">Спасибо, все понятно!</lego:b-pseudo-link>
                    </lego:action>
                </lego:column>
                <lego:column lego:type="gap-right"><lego:gap/></lego:column>
            </lego:layout>
        </lego:wrap>
    </xsl:template>

    <xsl:template match="lego:b-smart-help/lego:placeholder">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <lego:message lego:type="error" lego:visibility="visible">Извините, что-то пошло не&#160;так. Попробуйте позднее.</lego:message>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-smart-help/lego:action[@lego:type = 'open']">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <lego:b-pseudo-link lego:is-bem="yes">
                <xsl:attribute name="url">
                    <xsl:text>http://feedback.yandex.ru?from=</xsl:text>
                    <xsl:value-of select="ancestor::lego:b-smart-help[1]/@from-prj"/>
                </xsl:attribute>
                <xsl:text>Обратная связь</xsl:text>
                <lego:loader lego:type="sweet"/>
            </lego:b-pseudo-link>
            <lego:opener-bg/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-smart-help/lego:dataprovider">
        <lego:declaration>
            <lego:i-request lego:type="ajax"/>
        </lego:declaration>
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <!--
    <xsl:template match="lego:b-smart-help/lego:reclama">
        <lego:column lego:type="right">
            <xsl:copy-of select="."/>
        </lego:column>
    </xsl:template>
    -->

</xsl:stylesheet>

