<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-smart-help">
    <xsl:element name="{x:if(lego:action[@lego:type = 'open'], 'span', 'div')}">
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </xsl:element>
</xsl:template>

<xsl:template match="lego:b-smart-help" mode="lego:block-class-content">
    <xsl:apply-imports/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="lego:placeholder | lego:action[@lego:type = 'open']" mode="lego:block-class-content"/>
</xsl:template>

<xsl:template match="lego:b-smart-help" mode="lego:block-class-js">
    <xsl:apply-imports/>
    <xsl:text> i-bem</xsl:text>
</xsl:template>

<xsl:template match="lego:b-smart-help" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:text>,id:</xsl:text>
    <xsl:value-of select="x:js-quote(@id)"/>
    <xsl:text>,apiUrl:</xsl:text>
    <xsl:value-of select="x:js-quote(concat(
        'http://help.yandex.ru/smart-help/api/',
        $lego:params/lego:lego-version,
        '/xscript/_b-smart-help.xml'))"/>
    <xsl:if test="@prj">
        <xsl:text>,prjId:</xsl:text>
        <xsl:value-of select="x:js-quote(@prj)"/>
    </xsl:if>
    <xsl:if test="@from-prj">
        <xsl:text>,fromPrj:</xsl:text>
        <xsl:value-of select="x:js-quote(@from-prj)"/>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-smart-help//lego:wrap | lego:b-smart-help//lego:inner | lego:b-smart-help//lego:search-results">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-smart-help//lego:more/lego:b-link" mode="lego:block-class-content">
    <xsl:apply-imports/>
    <xsl:text> b-smart-help__more</xsl:text>
</xsl:template>

<xsl:template match="lego:b-smart-help//lego:services/lego:b-menu" mode="lego:block-class-content">
    <xsl:apply-imports/>
    <xsl:text> b-smart-help__services</xsl:text>
</xsl:template>

<xsl:template match="lego:b-smart-help//lego:questions/lego:b-menu" mode="lego:block-class-content">
    <xsl:apply-imports/>
    <xsl:text> b-smart-help__questions</xsl:text>
</xsl:template>

<xsl:template match="
    lego:b-smart-help//lego:body | lego:b-smart-help//lego:body-i |
    lego:b-smart-help//lego:content-left-i | lego:b-smart-help//lego:content-right-i">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates/>
    </div>
</xsl:template>

</xsl:stylesheet>
