<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    >

    <xsl:output
        encoding="UTF-8"
        method="xml"
        indent="no"
    />

    <xsl:template match="/object">
        <lego:b-smart-help>
            <lego:b-static-text>
                <xsl:apply-templates select="@name"/>
                <xsl:apply-templates select="." mode="content"/>
            </lego:b-static-text>
            <content-id>
                <xsl:value-of select="x:get-state-arg('content-id')"/>
            </content-id>
        </lego:b-smart-help>
    </xsl:template>

    <xsl:template match="object" mode="content">
        <xsl:apply-templates select="param[@xslname = 'text' or @xslname = 'help' or @xslname = 'Article']" mode="docbook2html"/>
    </xsl:template>

    <xsl:template match="object[child]" mode="content">
        <lego:b-menu lego:layout="vert" lego:is-bem="yes">
            <xsl:apply-templates select="child"/>
        </lego:b-menu>
    </xsl:template>

    <xsl:template match="child">
        <lego:item>
            <lego:b-pseudo-link
                lego:type="wrap"
                lego:is-bem="yes"
                class="b-menu__item-selector"
                url="#{@id}">
                <xsl:value-of select="@name"/>
            </lego:b-pseudo-link>
        </lego:item>
    </xsl:template>

    <xsl:template match="object/@name">
        <h1><xsl:value-of select="."/></h1>
    </xsl:template>

    <xsl:template match="*" mode="docbook2html">
        <xsl:variable name="tag">
            <xsl:apply-templates select="." mode="docbook2html-tag"/>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$tag != ''">
                <xsl:element name="{$tag}">
                    <xsl:apply-templates select="." mode="docbook2html-content"/>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="docbook2html-content"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="*" mode="docbook2html-content">
        <xsl:apply-templates mode="docbook2html"/>
    </xsl:template>

    <xsl:template match="*" mode="docbook2html-tag"/>

    <xsl:template match="title" mode="docbook2html-tag">
        <xsl:value-of select="concat('h', 1 + count(ancestor::section))"/>
    </xsl:template>

    <xsl:template match="title[not(parent::section)]" mode="docbook2html-tag">strong</xsl:template>

    <xsl:template match="para" mode="docbook2html-tag">p</xsl:template>

    <xsl:template match="section/subtitle | emphasis" mode="docbook2html-tag">strong</xsl:template>

    <xsl:template match="programlisting" mode="docbook2html-tag">pre</xsl:template>

    <xsl:template match="programlisting" mode="docbook2html-content">
        <code>
            <xsl:apply-templates mode="docbook2html"/>
        </code>
    </xsl:template>

    <xsl:template match="itemizedlist" mode="docbook2html-tag">ul</xsl:template>

    <xsl:template match="orderedlist" mode="docbook2html-tag">ol</xsl:template>

    <xsl:template match="itemizedlist/title | orderedlist/title" mode="docbook2html-tag">p</xsl:template>

    <xsl:template match="itemizedlist/title | orderedlist/title" mode="docbook2html-content">
        <code>
            <xsl:choose>
                <xsl:when test="@role = 'important' ">
                    <strong><xsl:apply-templates mode="docbook2html"/></strong>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates mode="docbook2html"/>
                </xsl:otherwise>
            </xsl:choose>
        </code>
    </xsl:template>

    <xsl:template match="listitem/para" mode="docbook2html-tag">li</xsl:template>

    <xsl:template match="listitem/para[@role = 'important']" mode="docbook2html-content">
        <li>
            <strong>
                <xsl:apply-templates mode="docbook2html"/>
            </strong>
        </li>
    </xsl:template>

    <xsl:template match="ulink | olink" mode="docbook2html-tag">a</xsl:template>

    <xsl:template match="ulink | olink" mode="docbook2html-content">
        <xsl:attribute name="href">
            <xsl:value-of select="@url | @targetdocent"/>
        </xsl:attribute>
        <xsl:if test="@role = 'noindex'">
            <xsl:attribute name="rel">nofollow</xsl:attribute>
        </xsl:if>
        <xsl:copy-of select="@target | @class | @title | @onclick"/>
        <xsl:apply-templates mode="docbook2html"/>
    </xsl:template>

    <xsl:template match="ulink[@role = 'hyper' or @type = 'hyper']" mode="docbook2html">
        <lego:b-pseudo-link url="#{@url}" lego:is-bem="yes" class="b-smart-help__article">
            <xsl:apply-templates mode="docbook2html"/>
        </lego:b-pseudo-link>
    </xsl:template>

    <xsl:template match="imagedata | inlinegraphic" mode="docbook2html-tag">img</xsl:template>

    <xsl:template match="imagedata | inlinegraphic" mode="docbook2html-content">
        <xsl:attribute name="src">
            <xsl:value-of select="@fileref"/>
        </xsl:attribute>
        <xsl:if test="../../textobject/phrase">
            <xsl:attribute name="alt">
                <xsl:value-of select="../../textobject/phrase"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:copy-of select="@class | @align | @valign | @width | @height"/>
    </xsl:template>

</xsl:stylesheet>
