<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exslt="http://exslt.org/common"
    xmlns:re="http://exslt.org/regular-expressions"
    extension-element-prefixes="x ya exslt"
    exclude-result-prefixes="lego x"
    >

    <xsl:template match="/" mode="lego:params">
        <lego:id>smart-help</lego:id>
    </xsl:template>

    <xsl:template match="/lego:page">
        <xsl:value-of select="x:http-header-out('Content-Type', 'text/javascript; charset=UTF-8')"/>
        <xsl:variable name="has-callback" select="re:test(x:get-query-arg('callback'), '^[\w_]+$')"/>
        <xsl:if test="$has-callback">
            <xsl:value-of select="concat(x:get-query-arg('callback'), '(')"/>
        </xsl:if>
        <xsl:text>{</xsl:text>
        <xsl:apply-templates select="
            lego:b-smart-help[lego:wrap] |
            lego:b-smart-help/lego:questions |
            lego:b-smart-help/lego:b-menu |
            lego:b-smart-help/lego:b-static-text |
            lego:b-smart-help/menu-id |
            lego:b-smart-help/content-id |
            lego:b-smart-help/lego:email |
            send
            " mode="json"/>
        <xsl:text>}</xsl:text>
        <xsl:if test="$has-callback">)</xsl:if>
    </xsl:template>

    <xsl:template match="/lego:page[.//xscript_invoke_failed]">
        <xsl:value-of select="x:set-http-status('500')"/>
    </xsl:template>

    <xsl:template match="*" mode="json">
        <xsl:if test="position() &gt; 1">,</xsl:if>
        <xsl:variable name="name">
            <xsl:apply-templates select="." mode="json-name"/>
        </xsl:variable>
        <xsl:variable name="content">
            <xsl:apply-templates select="." mode="json-content"/>
        </xsl:variable>
        <xsl:value-of select="concat(x:json-quote($name), ':', x:json-quote(x:xml2text($content)))"/>
    </xsl:template>

    <xsl:template match="*" mode="json-name"><xsl:value-of select="local-name()"/></xsl:template>

    <xsl:template match="lego:b-menu" mode="json-name">sections</xsl:template>

    <xsl:template match="lego:b-static-text" mode="json-name">article</xsl:template>

    <xsl:template match="lego:b-smart-help" mode="json-name">layout</xsl:template>

    <xsl:template match="*" mode="json-content">
        <xsl:apply-templates select="."/>
    </xsl:template>

    <xsl:template match="lego:b-smart-help" mode="json-content">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="lego:questions" mode="json-content">
        <xsl:apply-templates select=".">
            <xsl:with-param name="show" select="true()"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="send" mode="json-content"><xsl:value-of select="x:set-http-status('500')"/></xsl:template>
    <xsl:template match="send[sendmail-address-exception]" mode="json-content">email</xsl:template>
    <xsl:template match="send[send-form-ok]" mode="json-content">ok</xsl:template>

    <xsl:template match="lego:b-smart-help//lego:more">
        <xsl:call-template name="lego:apply">
            <xsl:with-param name="content">
                <lego:b-link url="http://help.yandex.ru/{x:get-query-arg('from-prj')}/" target="_blank">
                    <xsl:apply-templates/>
                </lego:b-link>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

</xsl:stylesheet>
