<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    >

    <xsl:output
        encoding="UTF-8"
        method="xml"
        indent="no"
    />

    <xsl:template match="/">
        <lego:b-smart-help>
            <lego:email>
                <xsl:variable name="main-email"
                    select="x:root/address-list/address[@is-permanent = 1 and contains(., '@ya.ru')]"/>
                <lego:b-form-input lego:is-bem="yes" name="email" value="{$main-email}">
                    <lego:label>Ваш эл.&#160;адрес для ответа</lego:label>
                    <lego:input/>
                    <lego:message lego:type="error">Неверный эл.&#160;адрес</lego:message>
                    <lego:samples>
                        <xsl:apply-templates select="$main-email | x:root/address-list/address[@is-permanent != 1]"/>
                    </lego:samples>
                </lego:b-form-input>
                <xsl:apply-templates select="." mode="meta-info"/>
            </lego:email>
        </lego:b-smart-help>
    </xsl:template>

    <xsl:template match="address">
        <xsl:if test="position() - 1">, </xsl:if>
        <lego:sample>
            <lego:b-pseudo-link lego:is-bem="yes">
                <xsl:apply-templates/>
            </lego:b-pseudo-link>
        </lego:sample>
    </xsl:template>

    <xsl:template match="/" mode="meta-info">
        <lego:b-static-text class="b-smart-help__meta-info">
            <input name="X-Address" type="hidden" value="{x:get-protocol-arg('remote_ip')}"/>
            <input name="X-Browser" type="hidden" value="{x:get-header('USER-AGENT')}"/>
            <input name="X-Proxy" type="hidden" value="{x:get-header('X-FORWARDED-FOR')}"/>
            <input name="yandexuid" type="hidden" value="{x:get-cookie('yandexuid')}"/>
            <input name="referer" type="hidden" value="{x:get-header('REFERER')}"/>
            <!--input name="from" type="hidden" value="default"/-->
            <input name="login" type="hidden" value="{x:get-state-arg('auth_login')}"/>
        </lego:b-static-text>
    </xsl:template>

</xsl:stylesheet>
