<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    >

    <xsl:output
        encoding="UTF-8"
        method="xml"
        indent="no"
    />

    <xsl:template match="/object">
        <lego:b-smart-help>
            <lego:b-menu lego:layout="vert" lego:theme="round" lego:is-bem="yes">
                <xsl:apply-templates select="child"/>
            </lego:b-menu>
            <menu-id>
                <xsl:value-of select="x:get-state-arg('menu-id')"/>
            </menu-id>
        </lego:b-smart-help>
    </xsl:template>

    <xsl:template match="child">
        <xsl:variable name="content-id" select="x:get-state-arg('content-id')"/>
        <lego:item>
            <xsl:if test="$content-id = @id">
                <xsl:attribute name="lego:state">current</xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="child">
                    <xsl:attribute name="lego:selectable">no</xsl:attribute>
                    <lego:trigger>
                        <xsl:apply-templates select="." mode="lego:b-pseudo-link"/>
                    </lego:trigger>
                    <lego:item-content>
                        <xsl:if test=".//child[@id = $content-id]">
                            <xsl:attribute name="lego:visibility">visible</xsl:attribute>
                        </xsl:if>
                        <lego:submenu>
                            <xsl:apply-templates select="child"/>
                        </lego:submenu>
                    </lego:item-content>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="." mode="lego:b-pseudo-link"/>
                </xsl:otherwise>
            </xsl:choose>
        </lego:item>
    </xsl:template>

    <xsl:template match="child" mode="lego:b-pseudo-link">
        <lego:b-pseudo-link lego:type="wrap" lego:is-bem="yes" url="#{ancestor::object[1]/@id}-{@id}">
            <xsl:choose>
                <xsl:when test="child">
                    <lego:b-ico lego:type="trigger"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">b-menu__item-selector</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>            
            <xsl:value-of select="@name"/>
        </lego:b-pseudo-link>
    </xsl:template>

</xsl:stylesheet>
