<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    >

    <xsl:output
        encoding="UTF-8"
        method="xml"
        indent="no"
    />

    <xsl:template match="/yandexsearch">
        <lego:b-smart-help>
            <xsl:apply-templates select="response/results"/>
        </lego:b-smart-help>
    </xsl:template>

    <xsl:template match="response/results"/>
    <xsl:template match="response/results[grouping/group/doc]">
        <xsl:variable name="properties" select="grouping/group/doc/properties"/>
        <xsl:if test="count(grouping/group/doc) = 1">
            <article content-id="{$properties/content}" menu-id="{$properties/prj}"/>
        </xsl:if>
        <lego:questions>
            <lego:title>
                <xsl:apply-templates select="." mode="title"/>
            </lego:title>
            <lego:b-menu lego:layout="vert" lego:is-bem="yes">
                <xsl:apply-templates select="grouping/group/doc"/>
            </lego:b-menu>
        </lego:questions>
    </xsl:template>

    <xsl:template match="results" mode="title">Возможно, вам поможет</xsl:template>

    <xsl:template match="doc">
        <lego:item>
            <lego:b-pseudo-link lego:type="wrap" lego:is-bem="yes" title="{title}" class="b-menu__item-selector">
                <xsl:apply-templates select="properties"/>
                <xsl:value-of select="title"/>
            </lego:b-pseudo-link>
        </lego:item>
    </xsl:template>

    <xsl:template match="properties">
        <xsl:attribute name="url">
            <xsl:value-of select="concat('#', prj, '-', content)"/>
        </xsl:attribute>
    </xsl:template>

</xsl:stylesheet>
