<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common" xmlns:x="http://www.yandex.ru/xscript" xmlns:xi="http://www.w3.org/2003/XInclude" version="1.0" extension-element-prefixes="x exsl">
    <xsl:template match="/">
        <send>
            <xsl:apply-templates>
                <xsl:with-param name="count" select="3"/>
            </xsl:apply-templates>
        </send>
    </xsl:template>

    <xsl:template match="*">
        <xsl:param name="count" select="1"/>
        <xsl:param name="i" select="1"/>

        <xsl:choose>
            <xsl:when test="$i &lt;= $count">
                <xsl:variable name="result">
                    <x:block threaded="no">
                        <x:id>Email</x:id>
                        <x:name>Yandex/Sendform</x:name>
                        <x:method>sendFormLocalWithSpamCheck</x:method>
                        <x:param type="State"/>
                        <x:param type="Request"/>
                        <x:param type="String">so_service,so_ip,so_host,so_realpath,so_form_name,so_email,so_subject,so_comment</x:param>
                        <x:param type="String">http://shingler2.yandex.ru:9000/check</x:param>
                        <x:param type="String">screenshort</x:param>
                        <x:param type="String">/var/cache/dps/stable/db/feedback/send_feedback.xsl</x:param>
                    </x:block>
                </xsl:variable>
                <xsl:apply-templates select="exsl:node-set($result)/*">
                    <xsl:with-param name="count" select="$count"/>
                    <xsl:with-param name="i" select="$i + 1"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <send-form-failed>
                    <xsl:attribute name="try-count">
                        <xsl:value-of select="$i - 1"/>
                    </xsl:attribute>
                </send-form-failed>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="send-form-ok | sendmail-address-exception">
        <xsl:param name="i" select="1"/>

        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="try-count">
                <xsl:value-of select="$i"/>
            </xsl:attribute>
            <xsl:copy-of select="node()"/>
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
