<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    >

    <xsl:output
        encoding="UTF-8"
        method="xml"
        indent="no"
    />

    <xsl:template match="*">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:form-question[x:get-query-arg('from-prj') = 'yaca']">
        <lego:form-question>
            <select name="subject"/>

            <lego:b-form-input lego:is-bem="yes" lego:type="textarea">
                <lego:mix><lego:msg b="b-smart-help"/></lego:mix>
                <lego:label>Сообщение</lego:label>
                <lego:hint>Опишите проблему подробнее</lego:hint>
                <lego:input name="message"/>
            </lego:b-form-input>

            <lego:b-form-input lego:is-bem="yes">
                <lego:mix><lego:fio b="b-smart-help"/></lego:mix>
                <lego:label>Как вас зовут</lego:label>
                <lego:input name="fio"/>
                <lego:samples/>
            </lego:b-form-input>

            <lego:b-form-input lego:is-bem="yes">
                <lego:mix><lego:siteurl b="b-smart-help"/></lego:mix>
                <lego:label>Адрес сайта</lego:label>
                <lego:input name="siteurl"/>
                <lego:samples/>
            </lego:b-form-input>

            <lego:b-form-input lego:is-bem="yes" name="email">
                <lego:mix><lego:email b="b-smart-help"/></lego:mix>
                <lego:label>E-mail для ответа</lego:label>
                <lego:input name="email"/>
                <lego:message lego:type="error">Неверный эл.&#160;адрес</lego:message>
                <lego:samples/>
            </lego:b-form-input>
        </lego:form-question>
    </xsl:template>


</xsl:stylesheet>
