/**
 * Создаёт css из файлов блока
 */

var lego = new (require('../../tools/lego').Lego)(process.argv[2]),
    util = require('../../tools/util');

var mods = lego.getModsFromFileSys('b-spin');
mods.map(function(m){
    m.vals.map(function(val){
        if (val.name == 'all') return;
        util.sha1sum('blocks/b-spin/_' + m.name + '/b-spin_' + m.name + '_' + val.name + '.gif', function (err, sha1) {
            if (err) throw err;

            var freeze_name = util.fixSha1Base64(sha1),
                freeze_url = '//yastatic.net/lego/_/' + freeze_name + '.gif',
                background = '\tbackground-image: url(' + freeze_url + ');',
                cssname = '.b-spin_' + m.name + '_' + val.name + '\n',
                css = cssname +
                        '{\n' +
                        '\twidth: ' + val.name + 'px;\n' +
                        '\theight: ' + val.name + 'px;\n\n' +
                        background +
                        '\n}';

            if ( m.name == 'theme') {
                var re = /(\w+)-([0-9]+)/,
                    valtheme = val.name.replace(re, '$2');
                css = cssname +
                    '{\n' +
                    '\twidth: ' + valtheme + 'px;\n' +
                    '\theight: ' + valtheme + 'px;\n\n' +
                    background +
                    '\n}';
            }

            util.writeFile('blocks/b-spin/_' + m.name + '/b-spin_' + m.name + '_' + val.name + '.css', css);
        });
    });
});
