<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<xsl:template match="lego:b-statcounter/lego:gemius">
    <xsl:copy>
        <!-- А тут перезаписываются определённые явно -->
        <xsl:apply-templates select="@lego:*"/>
        <xsl:apply-templates select="." mode="lego:gemius-code">
            <xsl:with-param name="country" select="'ua'"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="lego:gemius-code">
            <xsl:with-param name="country" select="'by'"/>
        </xsl:apply-templates>
        <xsl:apply-templates/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-statcounter/lego:gemius" mode="lego:gemius-code">
    <xsl:param name="country"/>
    <lego:code country="{$country}">
        <xsl:choose>
            <xsl:when test="@*[name() = $country]">
                <xsl:value-of select="@*[name() = $country]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="lego:gemius-code-content">
                    <xsl:with-param name="country" select="$country"/>
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </lego:code>
</xsl:template>

<xsl:template match="lego:b-statcounter/lego:gemius" mode="lego:gemius-code-content">
    <xsl:param name="country"/>
    <!-- Тут вставляются дефолтные коды -->
    <xsl:value-of select="document('b-statcounter__gemius.services.xml')/lego:services/lego:service[@id = $id]/@*[name() = $country]"/>
</xsl:template>

</xsl:stylesheet>
