<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    extension-element-prefixes = " x "
    version="1.0">

<!-- Счётчик для любых стран -->
<xsl:template match="lego:b-statcounter/lego:gemius[lego:code]">
    <xsl:apply-templates select="lego:code"/>
</xsl:template>

<xsl:template match="lego:b-statcounter/lego:gemius/lego:code">
    <xsl:variable name="country">
        <xsl:apply-templates select="." mode="lego:country"/>
    </xsl:variable>
    <xsl:if test="$country = 'true'">
        <xsl:apply-templates select="." mode="lego:counter-node"/>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-statcounter/lego:gemius/lego:code" mode="lego:counter-node">
    <img alt="">
        <xsl:apply-templates select="." mode="lego:src"/>
    </img>
</xsl:template>

<xsl:template match="lego:b-statcounter/lego:gemius/lego:code" mode="lego:country">false</xsl:template>
<xsl:template match="lego:b-statcounter/lego:gemius/lego:code[@country = 'ua']" mode="lego:country">
    <xsl:choose>
        <xsl:when test="lego:params()/lego:gemius/lego:region = '187'">true</xsl:when>
        <xsl:when test="lego:params()/lego:gemius/lego:region">false</xsl:when>
        <xsl:otherwise>
            <xsl:call-template name="lego:country">
                <xsl:with-param name="code" select="'187'"/>
                <xsl:with-param name="domain" select="name(.)"/>
            </xsl:call-template>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>
<xsl:template match="lego:b-statcounter/lego:gemius/lego:code[@country = 'by']" mode="lego:country">
    <xsl:choose>
        <xsl:when test="lego:params()/lego:gemius/lego:region = '149'">true</xsl:when>
        <xsl:when test="lego:params()/lego:gemius/lego:region">false</xsl:when>
        <xsl:otherwise>
            <xsl:call-template name="lego:country">
                <xsl:with-param name="code" select="'149'"/>
                <xsl:with-param name="domain" select="name(.)"/>
            </xsl:call-template>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="
    lego:b-statcounter/lego:gemius/lego:code
    " mode="lego:src">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'src'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:src-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:b-statcounter/lego:gemius/lego:code"  mode="lego:src-content"/>
<xsl:template match="lego:b-statcounter/lego:gemius/lego:code[@country = 'ua']"  mode="lego:src-content">
    <xsl:value-of select="concat('//yandexgaua.hit.gemius.pl/redot.gif?id=', .)"/>
</xsl:template>
<xsl:template match="lego:b-statcounter/lego:gemius/lego:code[@country = 'by']"  mode="lego:src-content">
    <xsl:value-of select="concat('//yandexgaby.hit.gemius.pl/redot.gif?id=', .)"/>
</xsl:template>

<xsl:template name="lego:country">
    <xsl:param name="code" select="'187'"/>
    <xsl:param name="domain" select="'ua'"/>

    <xsl:value-of select="x:set-state-string('lego-statcounter-gemius-code', $code)"/>
    <xsl:value-of select="x:set-state-string('lego-statcounter-gemius-domain', $domain)"/>

    <!-- Определение средствами xScript5 -->
    <xsl:variable name="result-domain">
        <!--TODO: разобраться тут с переменной -->
        <x:mist xpointer="/state/text()">
            <x:method>set_state_domain</x:method>
            <x:param type="String">tmp</x:param>
            <x:param type="ProtocolArg" as="String">originalhost</x:param>
            <x:param type="Long">1</x:param>
        </x:mist>
    </xsl:variable>
    <!-- Определение по IP -->
    <xsl:variable name="result-ip">
        <x:geo-block xpointer="/result/@code[. = '0']">
            <x:method>isIn</x:method>
            <x:param type="StateArg" as="String">lego-statcounter-gemius-code</x:param>
        </x:geo-block>
    </xsl:variable>
    <xsl:choose>
        <xsl:when test="$result-domain = $domain">true</xsl:when>
        <xsl:when test="$result-ip = '0'">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>
