BEM.DOM.decl({ name: 'b-subs', modName: 'action', modVal: 'subscribe' }, {

    onSetMod : {

        'js' : function() {

            this.__base();

            var _this = this;
            this.findBlockInside('b-form-input').on('change', function() {
                _this._checkEmail();
            });

            this
                ._checkEmail()
                ._checkSubscription();

        }

    },

    _checkSubscription : function() {

        Lego.params.uid?
            this._do(
                'maillists/' + this.params.slug + '/check',
                function(list) {

                    if(list.length) {
                        this._subscribeSuccessMessage(list[0]);
                    }
                    else {
                        this.showMessage('ok', '');
                        this.showForm();
                    }

                }) :
            this.showForm();

    },

    _checkEmail : function(e) {

        this._allowSubmit = /^[a-z0-9][\w\.\-~]*(\+[\w\.\-~]+)?\@([a-z0-9][\w\-]*\.)+[a-z]{2,4}$/i
                .test(this.findElem('email').val());

        var submit = this.findElem('submit');
        submit.attr('disabled', !this._allowSubmit);

        if ($.browser.msie && parseInt($.browser.version) < 9) {
            submit.css('position', 'relative');
            this.afterCurrentEvent(function() {
                submit.css('position', '');
            });
        }

        return this;

    },

    _onSubmit : function(e) {

        this.__base(e);

        if(!this._allowSubmit) return;

        this.findElem('email').blur().attr('disabled', true);

        this._do(
            'maillists/' + this.params.slug + '/subscribe',
            { email : this.findElem('email').val() },
            this.onSubscribeSuccess,
            this.onSubscribeError);

    },

    onSubscribeSuccess : function(list) {

        this.hideForm();
        this._subscribeSuccessMessage(list);

    },

    _subscribeSuccessMessage : function(list) {

        this.showMessage('ok', list.is_active?
            Lego.message('b-subs:subscribed', 'Вы подписаны на эту рассылку') :
            Lego.message('b-subs:emailed', 'Вам выслано письмо для подтверждения подписки'));

    },

    onSubscribeError : function() {

        this.showMessage('error', Lego.message('b-subs:dublicate', 'Этот адрес уже подписан'));
        this.findElem('submit').attr('disabled', false);
        this.findElem('email')
            .attr('disabled', false)
            .focus();

    }

});
