BEM.DOM.decl('b-subs', {

    onSetMod : {

        'js' : function() {

            this
                .bindTo('form', 'submit', this._onSubmit)
                .findElem('submit').attr('disabled', false);

        }

    },

    getDefaultParams : function() {

        return { apiUrl : 'http://subs.tst.yandex.ru/api/1.0/' };

    },

    _do : function(action, data, success, error) {

        if($.isFunction(data)) {
            error = success;
            success = data;
            data = {};
        }

        this.setMod(this.findElem('status'), 'type', 'load');

        $.ajax({
            url      : this.params.apiUrl + action + '/',
            dataType : 'jsonp',
            data     : $.extend(data, Lego.params.uid? {
                uid : Lego.params.uid,
                key : Lego.getCookie('yandexuid')
            } : {}),
            success  : this.changeThis(function(data) {
                data.error?
                    (error?
                        error.call(this, error) :
                        this.showSystemErrorMessage()) :
                    success.call(this, data);
            }),
            error    : this.changeThis(this.showSystemErrorMessage)
        });

    },

    showMessage : function(type, message) {

        this.setMod(this.findElem('status').text(message), 'type', type);

    },

    showSystemErrorMessage : function() {

        this.hideForm();
        this.showMessage('error', Lego.message('b-subs:error', 'Внутренняя ошибка, попробуйте позднее'));

    },

    showForm : function() {

        return this.setMod(this.findElem('form'), 'visibility', 'visible')

    },

    hideForm : function() {

        return this.delMod(this.findElem('form'), 'visibility');

    },

    _onSubmit : function(e) {

        e.preventDefault();

        this.findElem('submit').attr('disabled', true);

    }

}, {

});
