<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-subs">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <div class="{lego:name(.)}__i">
            <xsl:apply-templates select="." mode="lego:content"/>
        </div>
    </div>
</xsl:template>

<xsl:template match="lego:b-subs" mode="lego:block-class-js">
    <xsl:text> i-bem</xsl:text>
</xsl:template>

<xsl:template match="lego:b-subs" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:apply-templates select="@slug | @hash" mode="lego:js-params-content">
        <xsl:with-param name="need-comma" select="true()"/>
    </xsl:apply-templates>
    <xsl:text>,apiUrl:'</xsl:text>
    <xsl:apply-templates select="." mode="lego:b-subs_api-url"/>
    <xsl:text>'</xsl:text>
</xsl:template>

<xsl:template match="lego:b-subs" mode="lego:b-subs_api-url">http://subs-api.yandex.ru/api/1.0/</xsl:template>
<xsl:template match="lego:b-subs[@apiUrl]" mode="lego:b-subs_api-url">
    <xsl:value-of select="@apiUrl"/>
</xsl:template>

</xsl:stylesheet>

