(function($, Lego){

var useIframeUnder = !(($.browser.safari || $.browser.webkit) && navigator.userAgent.toLowerCase().indexOf('mobile') > -1),
    thisBlock = Lego.block['b-suggest'] = function(params){
        var thisSuggest = $(this),
            suggestHolder = $('<div class="b-suggest-popup"><i class="b-suggest__opera-gap"></i><div class="b-suggest-list">' +
                (useIframeUnder?
                    ('<iframe class="b-suggest__iframe" frameborder="0" src="javascript:' + "'<body style=\\'background:none\;overflow:hidden\\'>'" + '"></iframe>') :
                    '<div class="b-suggest__iframe"/>') +
                '<ul class="b-suggest-items"></ul>' +
                '<div class="b-suggest-nah"></div>' +
                '</div></div>').hide(),
            suggestItems = suggestHolder.find('.b-suggest-items'),
            suggestInput = thisSuggest.closest('form').find('input[name="' + (params['for'] || 'text') +'"]'),
            suggestForm = suggestInput.closest('form'),

            dataUrl = params.url || (params.host || '') + (params.path || ''),
            //dataUrl = dataUrl || 'http://suggest-dev.cloudkill.yandex.ru/suggest-market?callback=?',

            openInNewWindow = params.openInNewWindow = typeof params.openInNewWindow == 'undefined'? true : params.openInNewWindow,

            // для работы в режиме, когда страница с саджестом остаётся в рабочем состоянии долгое время
            permanent = !!params.permanent,

            cache = (function() { var res = {}; res['*' + dataUrl] = ['', []]; return res; })(), // кешируем запросы на сервер

            timeout = params.timeout || 700,

            // Статистика использования подсказки
            stats = {
                suggestType: params.suggestType || ((params.id == 'serp') ? 'serp_ru' : params.id),
                usageType: 'not_shown',
                region: '',
                nah: 'nah_not_shown',
                buttonByMouse: '',
                position: 'p0',
                session: (new Date().getTime() + Math.round(Math.random() * 10000)),
                queryTimes: [],
                ratio: {
                    userValue: 0,
                    finalValue: 0,
                    userActions: 0
                },
                text: '',
                user_input: '',
                pos: '',
                _keydownTriggered: false },

            lr = '',

            // функция удалённого запроса данных, выбирается или кроссфреймовая или обычная
            getData = params.getData? thisBlock.getDataFns[params.getData] : $.ajax,

            // функция получения текстового значения элемента
            getItemValue = function(item) {
                var params = item.length && item[0].onclick? item[0].onclick() : {};
                return params.value || item.find('.content').text() || item.text();
            },

            /**
             * @param {Element} input
             * @nosideeffects
             * @see http://stackoverflow.com/questions/4185821#4186100
             * @return {Number} Позиция конца выделения. Если ничего не выделено, то возвращается 0.
             */
            getSelectionEnd = function(input) {
                var end = 0;
                if(typeof(input.selectionEnd) == 'number') {
                    end = input.selectionEnd;
                } else {
                    var range = document.selection.createRange();
                    if(range && range.parentElement() == input) {
                        var len = input.value.length,
                            textInputRange = input.createTextRange();
                        textInputRange.moveToBookmark(range.getBookmark());

                        var endRange = input.createTextRange();
                        endRange.collapse(false);
                        end = textInputRange.compareEndPoints('EndToEnd', endRange) > -1 ?
                            len :
                            -textInputRange.moveEnd('character', -len);
                    }
                }
                return end;
            },

            // функция запроса и показа подсказок по определённой строке
            show = (function(){
                // вспомогательная функция построения html-я списка
                function buildItemHtml(item) {
                    /**
                     * (LEGO-6477, Firefox 10.0): Bug 714547 - Array passed from another domain behaves like Object
                     * https://bugzilla.mozilla.org/show_bug.cgi?id=714547
                     */
                    return ($.isArray(item) || typeof item.sort === 'function') && thisBlock.buildItemHtmlFns[item[0]] ?
                        thisBlock.buildItemHtmlFns[item[0]](item, { stats: stats, params: params }) :
                        // обычная подсказка
                        '<li><span class="b-suggest-elem b-suggest-elem-link"><span class="content">'
                            + highlightItem(item) + '</span></span></li>';
                }
                // вспомогательная функция построения html-я списка подсказок
                function show(data) {
                    stats.region = data[data.length - 1].r;
                    stats.exprt = data[data.length - 1].exprt;
                    var items = data[1];
                    if (!(count = items ? items.length : 0)) return hide();

                    if (stats.usageType != 'edit')
                        stats.usageType = 'not_used';

                    var hrefs = data[2] || [];
                    suggestItems
                        .html(
                            $.map(items, function(item, i){
                                return buildItemHtml(!!hrefs[i] ? ['href', item, hrefs[i]] : item);
                            }).join('')
                        )
                        .find('.b-suggest-elem').filter(':not(.b-suggest__elem_selectable_no)').bind('mouseenter mouseleave', function(e) {
                            $(this)[e.type == 'mouseenter'? 'addClass' : 'removeClass']('b-suggest-elem_state_hover');
                        });

                    countSelectable = items.length - suggestItems.find('.b-suggest__elem_selectable_no').length;

                    // n=0 - Включить мои запросы , n=1 Мои запросы включены, n = 2 Мои запросы отключены

                    suggestHolder.find('.b-suggest-close').hide();

                    if (suggestHolder.find('.b-suggest-nah').find('.b-suggest-nah__link').length == 0) {

                        switch(data[data.length - 1].n)
                        {
//                            case 0 :
//                                suggestHolder
//                                    .find('.b-suggest-nah')
//                                        .html('Включить <a class="b-suggest-nah__link" href="http://tune.yandex.ru/suggest/">мои запросы</a>')
//                                        .show();
//                                break;

                            case 1 :
                                suggestHolder
                                    .find('.b-suggest-list').addClass('b-suggest-list-nah_enabled').end()
                                    .find('.b-suggest-nah').addClass('b-suggest-nah_enabled')
                                        .html(thisBlock.buildHtmlMessageFns.nahLink('b-suggest.hah:on',
                                                Lego.message('b-suggest.hah:on', 'Мои запросы ((включены))'),
                                                Lego.message('b-suggest.hah:linkHref', 'http://tune.yandex.ru/suggest/')))
                                        .show();
                                break;

                            case 2 :
                                suggestHolder
                                    .find('.b-suggest-list').addClass('b-suggest-list-nah_disabled').end()
                                    .find('.b-suggest-nah').addClass('b-suggest-nah_disabled')
                                        .html(thisBlock.buildHtmlMessageFns.nahLink('b-suggest.hah:off',
                                                Lego.message('b-suggest.hah:off', 'Мои запросы ((отключены))'),
                                                Lego.message('b-suggest.hah:linkHref', 'http://tune.yandex.ru/suggest/')))
                                        .show();
                                break;

                            default :
                                    //пользователь не авторизован
                                suggestHolder
                                    .find('.b-suggest-close').show().end()
                                    .find('.b-suggest-nah').hide();
                                break;
                        }

                        // делаем так, чтобы по ссылке "Включены мои запросы" действительно можно было перейти
                        suggestHolder.find('.b-suggest-nah__link')
                            .bind('mousedown click', function() {
                                window.location = this.href
                            });
                    }

                    suggestHolder.show();
                    // Сохраняем для статистики действие "выбрали стрелками и отредактировали"
                    if (hidden === false && stats._keydownTriggered === true) {
                        stats.usageType = 'edit';
                        stats._keydownTriggered = false;
                    }
                    hidden = false;
                }
                var requestNumber = 0, // переменная для обеспечения последовательности удалённых запросов
                    optionalSuggest = thisSuggest.hasClass('b-suggest_reaction_changing'),
                    showSuggest, // включено или выключено показывание подсказки
                    originalValue; // оригинальное значение

                return function(value) {
                    if (closed) return; // если подсказки были закрыты пользователем, не делаем ничего

                    if (optionalSuggest) {
                        // если запрос не включен изначально, он включается только после изменения
                        // value
                        typeof originalValue == 'string' || (originalValue = value);
                        originalValue == value || (showSuggest = true);
                        if (!showSuggest) return;

                        showSuggest = false;
                        originalValue = value;
                    }

                    current(0, value);
                    var data = cache[value + '*' + dataUrl];
                    if (data) {
                        show(data);
                    } else {
                        var timer = setTimeout(hide, timeout); // если ответа долго нет, прячем подсказки
                        requestNumber += 1;
                        // Запоминаем timestamp отправки запроса
                        var queryTime = new Date();

                        // Получаем значение параметра lr
                        var lrField = document.getElementsByName('lr'),
                            lrParam;

                        // Fix possible IE access violation error
                        try {
                             lrParam = window.location.toString().match(/lr=(.*?)(&|$)/);
                        } catch(e) {
                            lrParam = '';
                        }

                        if (lrField.length > 0) lr = lrField[0].value;
                        else if (lrParam && lrParam.length > 0) lr = lrParam[1];
                        else lr = '';

                        getData({
                            url: dataUrl,
                            data: $.extend(
                                {
                                    part: suggestInput.val(),
                                    pos: getSelectionEnd(suggestInput[0]),
                                    lr: lr
                                },
                                Lego.params.yandexuid?
                                    { yu : Lego.params.yandexuid } :
                                    null),
                            dataType: 'json',
                            type: 'GET',
                            timeout: timeout,
                            success: (function(i, url) { return function(data){
                                if (!data) return;
                                cache[value + '*' + url] = data;
                                clearTimeout(timer);
                                if (i == requestNumber) show(data);
                                // Сохраняем в статистику время выполнения запроса
                                stats.queryTimes.push(new Date() - queryTime);
                            }})(requestNumber, dataUrl)
                        });
                    }
                }
            })(),
            // вспомогательная ф-ия перехода по ссылке
            openLink = function(url) {
                submitNavStats();
                // для режима permanent надо прятать форму, поэтому display:none
                window.setTimeout(function() {
                    $('<form style="display:none" action="' + url + '" method="get"' +
                            (openInNewWindow? ' target="_blank"' : '') + '/>')
                        .appendTo($('body'))
                        .submit()
                        .remove();
                }, 500);
            },

            closed = false, // храним факт закрытия подсказок пользователем
            hidden = true, // храним факт скрыты ли подсказки, безотносительно пользователем или автоматически
            metaKeyPressed = false, // храним факт нажатия метаклавиш
            // функция скрытия, в том числе меняет пользовательский текст
            hide = (function(){
                if (hidden) return;
                suggestHolder.hide();
                current(0, suggestInput.val());
                hidden = true;
            }),
            count = 0, // текущее количество вариантов
            countSelectable = 0, // текущее количество выбираемых вариантов
            // функция переключения варианта подсказки
            // i подразумевается 0 (для выбора пользовательского текста), 1 или -1 (для перемещения вверх/вниз)
            // value устанавливает пользовательский текст
            current = (function(){
                var current = 0,
                    userValue = suggestInput.val();
                return function(i, value) {
                    if (value != undefined) userValue = value;
                    current = i ? current + i : 0;
                    if (current < 0) current = countSelectable;
                    if (current > countSelectable) current = 0;
                    if (current > 0) stats.position = 'p' + current; // Positive 'current' value holds the position of a current item
                    var item = suggestItems.find('.b-suggest-elem').filter(':not(.b-suggest__elem_selectable_no)')
                            .removeClass('b-suggest-elem_selected')
                            .eq(current? current - 1 : 1000).addClass('b-suggest-elem_selected'), // затычка про 1000, потому что в Safari 3 undefined в eq работает некорректно
                        itemValue = getItemValue(item),
                        currentValue = item.is('.b-suggest-elem_nav') ? lastUserValue : (itemValue || userValue),
                        attrHref = item.attr('href'),
                        currentHref = itemValue && attrHref ? attrHref : '';
                    suggestInput.val() != currentValue && suggestInput.val(currentValue);
                    suggestInput.data('href', currentHref);
                }
            })();

        var focused = suggestInput.data('lego:focused');
        if(focused) suggestInput.blur();
        suggestInput.attr('autocomplete', 'off');
        if(focused) suggestInput.focus();
        if (params.text) suggestInput.val(params.text);
        thisSuggest.append(suggestHolder);

        // кнопка "закрыть" закрывает попап
        var closeInProgress = false; // переменная для синхронизации событий закрытия по ссылке и ухода из инпута


        // скрываем при глобальном лего-событии закрытия попапов
        $(document)
            .bind('popupsClose.lego', hide)
            // запоминаем нажатие метаклавиш
            .keydown(function(e){ if (e.metaKey || e.ctrlKey || e.altKey || e.shiftKey) metaKeyPressed = true })
            .keyup(function(e){ metaKeyPressed = false })
            .mouseup(function(){ closeInProgress = false });

        // считаем клики на кнопку "Найти"
        suggestForm.find(':submit').click(function(){
            stats.buttonByMouse = 'button_by_mouse';
        });

        suggestItems
            // клик по варианту выбирает его как пользовательский текст и выполняет переход
            .mousedown(function(e){
                closeInProgress = true; // предотвращаем проблемы со скрытием на уход из инпута
                var t = $(e.target);
                if (t.is('li *')) {
                    mouseDownElem = t.closest('.b-suggest-elem');
                    if(mouseDownElem.hasClass('b-suggest-elem_nav')) {
                        submitNavStats();
                    } else if(!mouseDownElem.hasClass('b-suggest__elem_selectable_no')) {
                        current(0, getItemValue(mouseDownElem));
                        suggestInput.data('href', mouseDownElem.attr('href'));

                        /* Find item's position in the list while mouse-clicking (begin) */
                        var container = t.parents('ul'),
                            targetClassName = e.target.className;

                        if (targetClassName && targetClassName.split(' ').length > 0) {
                            container.find('.' + targetClassName.split(' ')[0]).each(function(i) {
                                if (this == e.target) {
                                    stats.position = 'p' + (i + 1);
                                    t.hasClass('b-suggest-elem_nah') && (stats.nah = 'nah_used');
                                }
                            });
                        }
                        /* Find item's position in the list (end) */

                        stats.usageType = 'mouse';
                        if (!permanent) {
                            closed = true;
                        }
                        if (mouseDownElem.get(0).tagName.toLowerCase() != "a") {
                            setTimeout(function() { suggestForm.submit() }, 0); // выполняем переход
                        } else {
                            submitStats();
                        }
                    }
                }
                return false;
            })
            .click(function(){
                if (permanent) {
                    hide();
                }
                else {
                    $.browser.msie ? hide() : suggestInput.focus();
                }
            });

        var lastUserValue = '', // переменная для слежения за последним набранным пользователем текстом
            mouseDownElem,
            preventSubmit = false;

        suggestForm.submit(function(e){

            if(params.preventSubmit) {
                hide();
                closed = true;
                submitStats();
                setTimeout(function() { closed = false; }, 100);
                return false;
            }

            if (preventSubmit) {
                return preventSubmit = false;
            }

            var href = suggestInput.data('href') || stats.followAfterSubmit;

            // если не делать blur() для permanent-режима, то после сабмита саджестор
            // мгновенно ре-инициализируется заново, а нам надо его скрыть
            if (permanent) {
                suggestInput.blur();
            }

            if (!stats.submitted) {
                e.preventDefault();
                // Сохраняем URL, если есть, потому что он потеряется после сабмита статистики (сработает hide())
                if (href)
                    stats.followAfterSubmit = href;

                stats.user_input = lastUserValue;
                stats.text = suggestInput.val();
                stats.ratio.userValue = lastUserValue.length;
                stats.ratio.finalValue = stats.text.length;
                submitStats();

                window.setTimeout(function() { suggestForm.submit() }, 500);
            } else if (href && !permanent) {
                e.preventDefault();
                location.href = href;
            } else if (href && permanent) {
                e.preventDefault();
                openLink(href);
            }
        });

        function onEscape() { // вспомогательная функция, вызывается когда на инпуте или списке нажат esc
            current(0);
            hide();
            closeInProgress = false;
        }

        suggestInput
            .blur(function(event) { // скрываем при уходе из инпута
                if(event.originalEvent && !event.originalEvent.preventDefault) {
                    // Чиним моргающий в IE suggest, когда текст вводится с виртуальной клавиатуры.
                    // В IE < 9 после каждого нажатия клавиши теряется фокус и ставится обратно заново.
                    // В других браузерах фокус не теряется. Это происходит из-за того, что IE < 9 не
                    // поддерживает event.preventDefault() и в mousedown он не срабатывает.
                    setTimeout(function() {
                        if(!closeInProgress && suggestInput[0] != document.activeElement)
                            hide();
                    }, 84);
                } else if(!closeInProgress) {
                    hide();
                }
            })
            .click(function() {
                if(!hidden && !suggestInput.val()) {
                    lastUserValue = '';
                    hide();
                }
                stats.pos = getSelectionEnd(suggestInput[0]);
            })
            .keydown(function(e){
                switch(e.keyCode) {
                    // нажатие стрелок перемещает курсор и открывает список если он закрыт
                    case 38: // UP
                    case 40: // DOWN
                        e.preventDefault();
                        stats._keydownTriggered = true;
                        if (hidden) {
                            closed = false; // считаем что пользователь вызвал подсказки вручную
                            show(suggestInput.val());
                        } else {
                            stats.usageType = 'keyboard';
                            current(e.keyCode - 39); // пользуемся особенностями кодов клавиш "вверх"/"вниз" ;-)
                        }
                        break;

                    case 13: // Enter
                        break;

                    case 27: // ESC
                        closeInProgress = true;
                        break;
                }
                setTimeout(function(){
                    lastUserValue != suggestInput.val() && stats.ratio.userActions++;
                }, 1);
            })
            .keypress(function(e) {
                switch(e.keyCode) {
                    case 13: // Enter
                        closeInProgress = true;

                        var selectedItem = suggestItems.find('.b-suggest-elem_selected');
                        if(selectedItem.hasClass('b-suggest-elem_nav')) {
                            preventSubmit = true;
                            openLink(selectedItem.attr('href'));
                            permanent && hide();
                        } else {
                            selectedItem.hasClass('b-suggest-elem_nah') && (stats.nah = 'nah_used');

                            permanent || (closed = true);
                            suggestForm.submit();
                            hide();
                        }

                        return false;

                    case 27: // ESC
                        return false;

                }
            })
            .keyup(function(e){
                stats.pos = getSelectionEnd(suggestInput[0]);
                switch(e.keyCode) {
                    // ничего не делаем ибо работает keydown
                    case 38: // UP
                    case 40: // DOWN
                        break;

                    case 27:
                        onEscape();
                        break;

                    default:
                        // проверяем изменился ли текст и пытаемся подсказать
                        if (lastUserValue != suggestInput.val()) {
                            stats.endTime = new Date().getTime();
                            stats.startTime || (stats.startTime = stats.endTime);
                            lastUserValue = suggestInput.val();
                            clearInterval(keypressTimeout);
                            var keypressTimeout = setTimeout(function(){ show(suggestInput.val()) }, 1); // задержка для тех, кто быстро печатает
                        }
                        break;
                }
            });

        setTimeout(function() {
            // фокус в поле показывает подсказки
            suggestInput.focus(function(e) {
                // NOTE: костыль из-за LEGO-476
                if ($(e.target).data('b-suggest') !== false) {
                    closeInProgress = false;
                    show(suggestInput.val());
                }
            });
        }, 42);

        if (permanent) {
            // раз в полчаса чистим кеш, на всякий случай
            setInterval(function() {
                cache = {'' : []};
            }, 30 * 60 * 1000);
        }

        // событие для апдейта параметров
        // NOTE: пока умеет только учитывать изменения пути (без хоста)
        thisSuggest.bind('updateParams.lego', function(e, newParams){
            if (!newParams) return;
            var newDataUrl = (dataUrl.match(/^[^\/]*\/\/[^\/]+\//) || [''])[0] + (newParams.path || '');
            if (newDataUrl) dataUrl = newDataUrl;
            if ('closed' in newParams) closed = newParams.closed;
        });

        function submitStats() {
            if (Lego.params['show-counters']) {
                var params = [
                    [stats.suggestType, stats.usageType, stats.position, stats.nah, stats.buttonByMouse].join('.'),
                    'session=' + stats.session,
                    'region=' + stats.region,
                    'times=' + stats.queryTimes.join("."),
                    'pos=' + stats.pos,
                    'text=' + stats.text,
                    'user_input=' + stats.user_input,
                    'ratio=' + stats.ratio.userValue + '.' + stats.ratio.finalValue + '.' + stats.ratio.userActions
                ];
                var now = new Date().getTime();
                stats.startTime && params.push('since_first_change=' + (now - stats.startTime));
                stats.endTime && params.push('since_last_change=' + (now - stats.endTime));
                stats.exprt && params.push('exprt=' + stats.exprt);
                Lego.cp(
                    0, 2873,
                    params.join('/'));
            }
            permanent || (stats.submitted = true);
        }

        function submitNavStats() {
            Lego.params['show-counters'] &&
                Lego.cp(0, 70833, stats.suggestType + '/session=' + stats.session);
        }
    };

/**
 * highlightItem(['у', ['пячка']])
 * -> 'у<span class="b-suggest__highlight">пячка</span>
 *
 * @param {string|Array} item
 * @return {string}
 */
function highlightItem(item) {
    return item[0] == 'hl' ?
        $.map(item.slice(1), function(chunk) {
            return $.isArray(chunk)?
                '<span class="b-suggest__highlight">' + chunk[0] + '</span>' :
                chunk;
        }).join('') :
        item;
}

thisBlock.getDataFns = {};

thisBlock.buildItemHtmlFns = {
    // подсказка-ссылка
    'href': function(item, ctx) {
        if (item[3] && item[3].nah && item[3].nah == 1) { // ссылка из Моих находок (не посещенная, не добавляем b-suggest-elem-link)
            ctx.stats.nah == 'nah_not_shown' && (ctx.stats.nah = 'nah_not_used');
            return '<li><span class="b-suggest-elem b-suggest-elem_nah">' + highlightItem(item[1]) + '</span></li>';
        }
        return '<li><a class="b-suggest-elem b-suggest-elem-link" href="' + item[2] + '"><span class="content">' +
            highlightItem(item[1]) + '</span></a></li>';
    },

    // навигационная ссылка
    'nav': function(item, ctx) {
        return '<li><a class="b-suggest-elem b-suggest-elem-link b-suggest-elem_nav"' +
                (ctx.params.openInNewWindow? ' target="_blank"' : '') + ' href="http://' + (item[3] || item[2]) + '">' +
            '<span class="content"><span class="link">' + item[2] + '</span>' +
            '<span class="info">&nbsp;&mdash; ' + item[1] + '</span></span></a></li>'
    },

    // подсказка с произвольным html
    'html': function(item, ctx) {
        return '<li><span class="b-suggest-elem b-suggest-elem-link">' + item[1] + '</span></li>'
    },

    'fact': function(item, ctx) {
        return '<li><span class="b-suggest-elem b-suggest-elem-link b-suggest-elem-fact"><span class="content">' +
            item[1] + '</span><span class="b-suggest__fact"> &mdash; ' + item[2] + '</span>' +
        '</span></li>';
    }
};


thisBlock.buildHtmlMessageFns = {

    'nahLink': (function() {
        var _linkRe = /\(\(([^\)]+)\)\)/g,
            keys = {};

        return function(k, tpl, url) {
            if(!keys[k]) {
                keys[k] = tpl.replace(_linkRe, '<a class="b-suggest-nah__link" href="' + url +'">$1</a>');
            }
            return keys[k];
        }
    })()

};

})(jQuery, window.Lego);
