(function($, Lego){
var buildItemHtmlFns = Lego.block['b-suggest'].buildItemHtmlFns,
    old = buildItemHtmlFns.href,
    srvTitles = {
        images: 'картинки',
        market: 'маркет',
        video: 'видео',
        slovari: 'словари',
        music: 'музыка',
        adresa: 'адреса',
        maps: 'карты',
        rabota: 'работа',
        auto: 'авто',
        realty: 'недвижимость',
        news: 'новости',
        rasp: 'расписания',
        uslugi: 'услуги',
        browser: 'браузеры',
        opera: 'опера',
        cards: 'открытки',
        afisha: 'афиша',
        weather: 'погода'
    };

buildItemHtmlFns.href = function (item, ctx) {
    var item3 = item[3];
    if (item3 && item3.srv) {
        return '<li>' +
            '<a class="b-suggest-elem b-suggest-elem-link b-suggest-elem_srv" ' +
                'href="http://' + item3.srv + '.yandex.ru' + item[2] + '">' +
                '<span class="content">' +
                    '<span class="link">' + item[1] + '</span>' +
                    '<span class="srv">' + srvTitles[item3.srv] + '</span>' +
                '</span>' +
            '</a>' +
        '</li>';
    }
    return old(item, ctx);
}

})(jQuery, window.Lego);
