<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" exsl "
    exclude-result-prefixes=" x lego "
    version="1.0">

    <!-- ############################################################################################################## -->

<xsl:include href="../i-bem/i-bem.convert2xml.xsl"/>

<xsl:template match="lego:b-tabbed-pane">
    <lego:declaration>
        <xsl:variable name="i-bem">
            <lego:i-bem>
                <lego:dom/>
            </lego:i-bem>
        </xsl:variable>
        <xsl:apply-templates select="exsl:node-set($i-bem)"/>
        <lego:b-tabbed-pane>
            <lego:tabs>
                <lego:tab/>
            </lego:tabs>
        </lego:b-tabbed-pane>
    </lego:declaration>
    <xsl:copy>
        <xsl:apply-templates select="@*"/>
        <xsl:attribute name="lego:is-bem">yes</xsl:attribute>
        <xsl:apply-templates select="node()"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:tabs[lego:tab]">
    <xsl:copy>
        <lego:b-menu lego:layout="horiz-complex" lego:is-bem="yes">
            <xsl:apply-templates select="@lego:layout | @lego:preset | @lego:theme"/>
            <xsl:apply-templates select="lego:tab"/>
        </lego:b-menu>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane//lego:tab">
    <lego:item>
        <xsl:variable name="state">
            <xsl:apply-templates select="." mode="lego:current"/>
        </xsl:variable>
        <xsl:attribute name="class">
            <xsl:text>b-tabbed-pane__tab b-menu__item-selector</xsl:text>
            <xsl:if test="$state = 'current'"> b-tabbed-pane__tab_state_current</xsl:if>
        </xsl:attribute>
        <xsl:if test="$state = 'current'">
            <xsl:attribute name="lego:state">current</xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="." mode="lego:content"/>
    </lego:item>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane//lego:tab" mode="lego:content">
    <lego:b-pseudo-link url="#" lego:is-bem="yes">
        <lego:mix>
            <lego:link b="b-tabbed-pane"/>
        </lego:mix>
        <xsl:copy-of select="node()"/>
    </lego:b-pseudo-link>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane//lego:tab" mode="lego:current"/>

<xsl:template match="lego:b-tabbed-pane/lego:tabs/lego:tab[@lego:state = 'current']" mode="lego:current">
    <xsl:text>current</xsl:text>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane//lego:tab[position() = 1 and not(ancestor::lego:b-tabbed-pane/lego:tabs/lego:tab/@lego:state = 'current')]" mode="lego:current">
    <xsl:text>current</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-tabbed-pane/lego:panels">
    <xsl:copy>
        <xsl:apply-templates select="@*"/>
        <xsl:attribute name="lego:is-bem">yes</xsl:attribute>
        <xsl:apply-templates select="node()"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane//lego:panel">
    <xsl:copy>
        <xsl:apply-templates select="@*"/>
        <xsl:apply-templates select="." mode="lego:current"/>
        <xsl:apply-templates select="node()"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane//lego:panel" mode="lego:current"/>
<xsl:template match="lego:b-tabbed-pane//lego:panel[position() = 1 and not(ancestor::lego:b-tabbed-pane/lego:panels/lego:panel/@lego:state = 'current')]" mode="lego:current">
    <xsl:attribute name="lego:state">current</xsl:attribute>
</xsl:template>

</xsl:stylesheet>

