BEM.DOM.decl('b-tabbed-pane', {

    onSetMod : {

        'js' : function() {

            this._enableTabs();

        }

    },

    onElemSetMod : {

        'panel' : {

            'state': {

                'current' : function(elem) {

                    if (this.getPanel().index(elem) === -1) {
                        return;
                    }

                    this.currentPanel = elem;
                    var prevPanel = this.getPanel('state', 'current');

                    this
                        .delMod(prevPanel, 'state')
                        .trigger('current', {
                            prev    : prevPanel,
                            current : elem
                        });

                }

            }

        },
        'tab' : {
            'state' : {
                'current' : function(elem) {

                    if (this.getTab().index(elem) === -1) {
                        return;
                    }

                    this.currentTab = elem;
                    var prev = this.getTab('state', 'current');
                    this
                        .delMod(prev, 'state');
                }
            }
        }

    },

    /**
     * Возвращает контейнер панелей
     * @returns {jQuery} panels
     */
    getPanels: function (modName, modVal) {
        return this.domElem.filter(this.buildSelector('panels'));
    },

    /**
     * Возвращает панель
     * @param {String} [modName] имя модификатора
     * @param {String} [modVal] значение модификатора
     * @returns {jQuery} panel
     */
    getPanel: function (modName, modVal) {
        return this.getPanels().children(this.buildSelector('panel', modName, modVal));
    },

    /**
     * Возвращает контейнер табов
     * @returns {jQuery} tabs
     */
    getTabs: function () {
        return this.domElem.filter(this.buildSelector('tabs'));
    },

    /**
     * Возвращает таб
     * @param {String} [modName] имя модификатора
     * @param {String} [modVal] значение модификатора
     * @returns {jQuery} tab
     */
    getTab: function (modName, modVal) {
        return this.findElem(this.getTabs(), 'tab', modName, modVal);
    },

    /**
     * @nosideeffects
     * @param {jQuery} tab
     * @returns {jQuery} panel
     */
    getPanelByTab : function(tab) {
        return this.getPanel().eq(this.getTab().index(tab));
    },

    /**
     * @nosideeffects
     * @param {jQuery} panel
     * @returns {jQuery} tab
     */
    getTabByPanel : function(panel) {
        return this.getTab().eq(this.getPanel().index(panel));
    },

    /**
     * Включает/выключает слушание выбора пункта меню
     * @private
     * @param {Boolean} [enable=true]
     */
    _enableTabs : function(enable) {

        BEM.blocks['b-menu'][enable === false? 'liveCtxUnbind' : 'liveCtxBind'](
            this.getTabs(),
            'current',
            this._onSelectTab,
            this);

        return this;

    },

    /**
     * Обработчик выбора пункта меню
     * @param {$.Event} e событие
     * @param {Object} data данные
     */
    _onSelectTab : function(e, data) {


        this.selectByIndex(data.current? this.getTab().index(data.current) : -1);

    },

    /**
     * Показывает панель
     * @param {Number} index индекс панели
     */
    selectByIndex : function(index) {

        if (index >= 0) {
            var tab = this.getTab().eq(index);
            this
                ._enableTabs(false)
                .setMod(tab, 'state', 'current')
                .findBlockOn(this.getTabs(), 'b-menu').setMod(
                    tab,
                    'state',
                    'current');

            // включаем таб
            this
                .setMod(
                    this.getPanel().eq(index),
                    'state',
                    'current')
                ._enableTabs();

        } else {
            this
                .delMod(this.getTab('state', 'current'), 'state')
                .delMod(this.getPanel('state', 'current'), 'state');

            var menu = this.findBlockOn(this.getTabs(), 'b-menu');
            menu.delMod(menu.elem('item'), 'state');
        }

    },

    /**
     * Показывает панель
     * @param {Number} index индекс панели
     */
    toggleByIndex : function(index) {

        // включаем таб
        var tab = this.getTab().eq(index);
        this
            ._enableTabs(false)
            .toggleMod(tab, 'state', 'current', '')
            .findBlockOn(this.getTabs(), 'b-menu').toggleMod(
                tab,
                'state',
                'current',
                '');

        this
            .toggleMod(
                this.getPanel().eq(index),
                'state',
                'current',
                '')
            ._enableTabs();

    },

    destruct : function() {

        this
            ._enableTabs(false)
            .__base.apply(this, arguments);

    }

}, {

    live : function() {

        this.liveInitOnBlockInit('b-menu');

    }

});
