<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:x="http://www.yandex.ru/xscript"
    exclude-result-prefixes=" lego "
    version="1.0">

<xsl:template match="lego:b-tags">
    <lego:declaration>
        <lego:b-menu lego:layout="horiz">
            <lego:title/>
        </lego:b-menu>
    </lego:declaration>

    <lego:b-tags>
        <xsl:copy-of select="@*"/>
        <lego:b-menu lego:type="tags" lego:layout="horiz">
            <xsl:copy-of select="@lego:is-bem | @lego:mode"/>
            <xsl:apply-templates select="lego:title"/>

            <xsl:for-each select="lego:tag[not(position = 1)]">
                <lego:item>
                    <xsl:copy-of select="@lego:state"/>
                    <xsl:apply-templates select="."/>
                </lego:item>
            </xsl:for-each>

            <xsl:apply-templates select="lego:more"/>
        </lego:b-menu>
    </lego:b-tags>
</xsl:template>

<xsl:template match="lego:b-tags//lego:link">
    <lego:b-link>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </lego:b-link>
</xsl:template>
<xsl:template match="lego:b-tags[lego:is-bem]//lego:link">
    <lego:b-pseudo-link lego:is-bem="yes" class="b-menu__item-selector">
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </lego:b-pseudo-link>
</xsl:template>

</xsl:stylesheet>
