<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    exclude-result-prefixes="lego"
    >

<xsl:template match="lego:b-tags/lego:b-menu" mode="lego:b-menu__layout">
    <xsl:apply-imports/>
    <xsl:apply-templates select="lego:more"/>
</xsl:template>

<xsl:template match="lego:b-tags/lego:b-menu" mode="lego:block-class-content">
    <xsl:apply-imports/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates select=".." mode="lego:block-class-content"/>
</xsl:template>

<xsl:template match="lego:b-tags//lego:tag">
    <span>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates/>
    </span>
</xsl:template>

<xsl:template match="lego:b-tags//lego:more">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="lego:b-tags//lego:tag | lego:b-tags//lego:title | lego:b-tags//lego:more | lego:b-tags//lego:tag/lego:text[not(@lego:type = 'count')]" mode="lego:block-class-content-name">
    <xsl:value-of select="concat(local-name(ancestor::lego:b-tags[lego:is-block(.)][1]), '__', local-name(.))"/>
</xsl:template>

<xsl:template match="lego:b-tags//lego:tag/lego:b-link" mode="lego:block-class-content-name">
    <xsl:value-of select="concat(local-name(.), ' ', local-name(ancestor::lego:b-tags[lego:is-block(.)][1]), '__link')"/>
</xsl:template>

</xsl:stylesheet>
