<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:func="http://exslt.org/functions"
    extension-element-prefixes=" func "
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template name="lego:b-user">
    <xsl:param name="title"/>
    <xsl:param name="link"/>
    <xsl:param name="counter"/>
    <xsl:param name="maxlength"/>
    <xsl:param name="maxlength-relative"/>

    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-user url="{$link}" counter="{$counter}" maxlength="{$maxlength}" maxlength-relative="{$maxlength-relative}">
                <xsl:value-of select="$title"/>
            </lego:b-user>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<func:function name="lego:b-user">
    <xsl:param name="title"/>
    <xsl:param name="link"/>
    <xsl:param name="counter"/>
    <xsl:param name="maxlength"/>
    <xsl:param name="maxlength-relative"/>

    <func:result>
        <xsl:call-template name="lego:apply">
            <xsl:with-param name="content">
                <lego:b-user url="{$link}" counter="{$counter}" maxlength="{$maxlength}" maxlength-relative="{$maxlength-relative}">
                    <xsl:value-of select="$title"/>
                </lego:b-user>
            </xsl:with-param>
        </xsl:call-template>
    </func:result>
</func:function>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-user | lego:b-user[$lego:locale = 'tr']">
    <b>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </b>
</xsl:template>

<xsl:template match="lego:b-user[normalize-space(@url)]">
    <b>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <a class="b-user__link">
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:apply-templates select="." mode="lego:counter"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </a>
    </b>
</xsl:template>

<xsl:template match="lego:b-user" mode="lego:content">
    <xsl:variable name="clever" select="lego:clever-substring(., @maxlength, @maxlength-relative)"/>
    <xsl:if test=". != $clever">
        <xsl:attribute name="title"><xsl:value-of select="."/></xsl:attribute>
    </xsl:if>
    <b class="b-user__first-letter"><xsl:value-of select="substring($clever, 1, 1)"/></b>
    <xsl:value-of select="substring($clever, 2)"/>
</xsl:template>

</xsl:stylesheet>
