<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:math="http://exslt.org/math"
    exclude-result-prefixes=" lego x math "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-userpic">
    <a href="http://i.yandex.ru/?avatar">
        <xsl:apply-templates select="." mode="lego:block-class"/>
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

<xsl:template match="lego:b-userpic[$lego:locale = 'tr']">
    <span>
        <xsl:apply-templates select="." mode="lego:block-class"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </span>
</xsl:template>

<xsl:template match="lego:b-userpic" mode="lego:content">
    <img class="b-userpic__img" alt="" onerror="this.style.display = 'none'">
        <xsl:apply-templates select="." mode="lego:src"/>
    </img>
    <i class="b-userpic__i"></i>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-userpic[@url]" mode="lego:url-content">
    <xsl:value-of select="@url"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-userpic" mode="lego:src-content">
    <xsl:text>//upics.yandex.net/</xsl:text>
    <xsl:choose>
        <xsl:when test="@uid"><xsl:value-of select="@uid"/></xsl:when>
        <xsl:when test="@login">get/<xsl:value-of select="@login"/></xsl:when>
        <xsl:when test="$lego:params/lego:uid"><xsl:value-of select="$lego:params/lego:uid"/></xsl:when>
        <xsl:otherwise>get/<xsl:value-of select="x:tolower($lego:params/lego:login)"/></xsl:otherwise>
    </xsl:choose>
    <xsl:if test="@lego:type">
        <xsl:text>/</xsl:text><xsl:value-of select="@lego:type"/>
    </xsl:if>
    <xsl:value-of select="concat('?rnd=', floor(math:random() * 10000000))"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:b-userpic">
    <xsl:param name="url" select="'http://i.yandex.ru/?avatar'"/>
    <xsl:param name="uid" select="$lego:params/lego:uid"/>
    <xsl:param name="login" select="$lego:params/lego:login"/>
    <xsl:param name="type" select="'middle'"/>
    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-userpic url="{$url}" uid="{$uid}" login="{$login}" lego:type="{$type}"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

