<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" exsl "
    exclude-result-prefixes=" lego exsl "
    >

    <xsl:template match="lego:b-wc-status">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="." mode="items"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-wc-status" mode="items">
        <xsl:variable name="default-items">
            <lego:item id="off">
                <lego:text>
                    <xsl:value-of select="$messages[@id = 'b-wc-status:off']"/>
                </lego:text>
            </lego:item>
            <lego:item id="history">
                <lego:link url="http://mail.yandex.ru/history">
                    <xsl:value-of select="$messages[@id = 'b-wc-status:history']"/>
                </lego:link>
            </lego:item>
            <lego:item id="setup">
                <lego:link url="http://online.yandex.ru/">
                    <xsl:value-of select="$messages[@id = 'b-wc-status:setup']"/>
                </lego:link>
            </lego:item>
            <lego:item id="faq">
                <lego:link url="http://online.yandex.ru/faq/">
                    <xsl:value-of select="$messages[@id = 'b-wc-status:faq']"/>
                </lego:link>
            </lego:item>
        </xsl:variable>
        <xsl:apply-templates select="exsl:node-set($default-items)" mode="items">
            <xsl:with-param name="custom-items" select="lego:item"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="lego:item" mode="items">
        <xsl:param name="custom-items"/>
        <xsl:choose>
            <xsl:when test="@id = $custom-items/@id">
                <xsl:copy-of select="$custom-items[@id = current()/@id]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
