(function($, Lego) {

    Lego.block['b-wc-status'] = function() {
        var $this = $(this),
            $wcToggle = $this.find('.c-toggle'),
            $wcPopup = $this.find('.b-wc-status__popup');

        $this.mouseenter(function() {
            $this.addClass('b-wc-status__hover');
        });

        $wcPopup
            .mouseenter(function() {
                window.clearTimeout($this.data('timeout'));
            })
            .mouseleave(function() {
                $this.data('timeout', setTimeout(hide, 1000));
            });

        $(document).click(function(e) { if(!$(e.target).is('.b-wc-status *')) hide() });

        function hide() {
            $this.removeClass('b-wc-status__hover');
        }

        $wcToggle.click(function() {
            $(document).trigger(
            	'setStatus.WebChat',
            	[$this.hasClass('b-wc-status_type_off') ? 'online' : 'offline']
            );
            hide();
            return false;
        });

        $(document).bind('status.WebChat', function (_, webchat_status) {
        	var online = (webchat_status == 'online');
        	$this.toggleClass('b-wc-status_type_off', !online);
        	$wcToggle.html(online ? "выключить" : "включить");
        })
	};

})(jQuery, window.Lego);
