<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

    <xsl:template match="lego:b-widget">
        <div>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="." mode="lego:mouseactions"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </div>
    </xsl:template>

    <xsl:template match="lego:b-widget" mode="lego:mouseactions">
        <!-- TODO : переделать на bem-блок -->
        <xsl:attribute name="onmouseover">
            <xsl:text>this.className+=' b-widget_over'</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="onmouseout">
            <xsl:text>this.className=this.className.replace(' b-widget_over', '')</xsl:text>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="lego:b-widget/lego:head">
        <table>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <tr>
                <td class="l">
                    <b>
                        <i/>
                    </b>
                </td>
                <xsl:apply-templates select="lego:title"/>
                <xsl:apply-templates select="ancestor-or-self::lego:b-widget" mode="lego:controls"/>
                <!-- тут будут контролы -->
                <td class="r">
                    <b>
                        <i/>
                    </b>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="lego:b-widget" mode="lego:controls">
        <td/>
        <td/>
    </xsl:template>

    <xsl:template match="lego:b-widget[.//lego:controls]" mode="lego:controls">
        <xsl:apply-templates select=".//lego:controls/lego:control"/>
    </xsl:template>

    <xsl:template match="lego:b-widget//lego:control">
        <td>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <a class="{@lego:action}" onclick="return false" href="">
                <b><i/></b>
            </a>
        </td>
    </xsl:template>

    <xsl:template match="lego:b-widget//lego:title">
        <td>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <div><span>
                <xsl:copy-of select="."/>
            </span></div>
        </td>
    </xsl:template>

    <xsl:template match="lego:b-widget/lego:frame">
        <table>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="lego:top"/>
            <xsl:apply-templates select="lego:content"/>
            <xsl:apply-templates select="lego:bottom"/>
        </table>
    </xsl:template>

    <xsl:template match="lego:b-widget//lego:top | lego:b-widget//lego:bottom">
        <tr>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <td>
                <i class="l"><i/></i>
            </td>
            <td/>
            <td>
                <i class="r"><i/></i>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="lego:b-widget//lego:content">
        <tr>
            <xsl:apply-templates select="." mode="lego:content"/>
        </tr>
    </xsl:template>

    <xsl:template match="lego:b-widget//lego:content/lego:*">
        <td>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </td>
    </xsl:template>

    <xsl:template match="lego:b-widget//lego:content/lego:center/lego:body">
        <div>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </div>
    </xsl:template>

    <xsl:template match="lego:b-widget//lego:body/lego:bg">
        <img>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:attribute name="alt"></xsl:attribute>
            <xsl:attribute name="src">http://img.yandex.net/i/widget/widget-bg.png</xsl:attribute>
        </img>
    </xsl:template>

    <xsl:template match="lego:b-widget//lego:body/lego:data">
        <div>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:copy-of select="node()"/>
        </div>
    </xsl:template>

</xsl:stylesheet>
