/**
 jquery.WrappableTable

 Динамически перестраиваемая таблица.

 При изменении размеров окна количество столбцов в таблице динамически
 изменяется, чтобы удовлетворить заданной минимальной ширине ячейки и
 расстоянию между ячейками.

 Пример: $(".table-container").wrappableTable({minWidth: 250, space: 2});
 */

(function($, Lego) {
    Lego.block['b-wrappable-table'] = function(params) {
        new $.WrappableTable(this, params);
    };

    $.WrappableTable = function(elem, params) {
        this.elem = elem.get(0);
        this.params = params;

        this.init();
    };

    $.WrappableTable.prototype = {
        init: function() {
            this.minWidth = parseInt(this.params.minWidth);
            this.space = parseInt(this.params.space);

            this.initLayout();
        },

        initLayout: function() {
            this.cells = [];
            this.classes = [];

            this.columns = 0;

            this.table = this.elem.getElementsByTagName("table")[0];

            var rows = this.table.rows;
            for (var i = 0, li = rows.length; i < li; i++) {
                var c = rows[i].className;
                var index = c.match(/\s*r(\d+?)\s*/)[1];

                this.classes[i] = c;

                if (!this.cells[index - 1]) {
                    this.cells[index - 1] = [];
                }

                for (var j = 0, lj = rows[i].cells.length; j < lj; j++) {
                    this.cells[index - 1].push(rows[i].cells[j]);
                }
            }

            this.columns = this.cells[0].length;

            var self = this;
            this.resize();
            setInterval(function() { self.resize(); }, 250);
        },

        count: function() {
            var c = Math.floor(this.elem.parentNode.offsetWidth / (this.minWidth + this.space));

            return c > 0 ? c : 1;
        },

        resize: function() {
            var cols = this.count();

            if (this.columns == cols) {
                return;
            }

            this.columns = cols;

            var newTable = document.createElement("table");
            var tbody = document.createElement("tbody");
            var rows = this.cells[0].length / cols;
            var width = 100 / cols;

            for (var i = 0; i < rows; i++) {
                for (var j = 0, lj = this.cells.length; j < lj; j++) {
                    var row = document.createElement("tr");
                    row.className = this.classes[j].replace(
                            /(^|\s+)(r\d+)(\s+|$)/,
                            function($0, $1, $2) {return $0.replace($2, "r" + (j + 1));});

                    for (var k = 0; k < cols; k++) {
                        var cell = this.cells[j][i * cols + k];
                        if (!cell) {
                            break;
                        }

                        cell.style.width = width + "%";
                        row.appendChild(cell);
                    }

                    tbody.appendChild(row);
                }
            }

            newTable.appendChild(tbody);
            this.elem.appendChild(newTable);

            this.table.parentNode.removeChild(this.table);
            this.table = newTable;
        }
    };
})(jQuery, window.Lego);
