<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-wrappable-table">
    <div>
        <xsl:copy-of select="*/@*"/>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="table"/>
    </div>
</xsl:template>

<!-- прокидование xhtml из lego-xml в результат -->
<xsl:template match="table | table//*">
    <xsl:element name="{local-name()}">
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates select="node()"/>
    </xsl:element>
</xsl:template>


<xsl:template match="lego:b-wrappable-table[table/@class]" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="table/@class"/>
</xsl:template>

<xsl:template match="lego:b-wrappable-table" mode="lego:block-class-js">
    <xsl:apply-imports/>
    <xsl:text> g-js</xsl:text>
</xsl:template>

<xsl:template match="lego:b-wrappable-table" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:text>,</xsl:text>
    <xsl:apply-templates select="@*" mode="lego:js-params-content"/>
</xsl:template>

</xsl:stylesheet>
