<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:wiki="https://lego.yandex-team.ru/wiki"
    extension-element-prefixes = " wiki "
    version="1.0">

    <xsl:import href="../../../tools/wiki-encode.xsl"/>

    <xsl:output method="text"/>

    <!-- Костыль для ситуации, когда jsdoc пустой: .wiki не может быть пустым, иначе ломается shmakowiki -->
    <xsl:template match="jsdoc[not(*)]">
        <xsl:text>Извините, здесь нет документации на API.</xsl:text>
    </xsl:template>

    <xsl:template match="class">
        <xsl:value-of select="concat('==', @name, ' (', wiki:encode(@src), ')')"/>
        <xsl:apply-templates select="desc"/>
        <xsl:text>&#xA;</xsl:text>
        <xsl:apply-templates select="members | static"/>
    </xsl:template>

    <xsl:template match="members | static">
        <xsl:variable name="properties">
            <xsl:apply-templates select="public/properties"/>
            <xsl:apply-templates select="protected/properties"/>
        </xsl:variable>
        <xsl:if test="string($properties)">
            <xsl:apply-templates select="." mode="properties-header"/>
            <xsl:copy-of select="$properties"/>
        </xsl:if>
        <xsl:variable name="methods">
            <xsl:apply-templates select="public/methods"/>
            <xsl:apply-templates select="protected/methods"/>
        </xsl:variable>
        <xsl:if test="string($methods)">
            <xsl:apply-templates select="." mode="methods-header"/>
            <xsl:copy-of select="$methods"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="members | static" mode="properties-header">
        <xsl:text>===</xsl:text>
        <xsl:apply-templates select="." mode="properties-header.text"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="members | static" mode="methods-header">
        <xsl:text>===</xsl:text>
        <xsl:apply-templates select="." mode="methods-header.text"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="members" mode="properties-header.text">
        <xsl:text>Поля</xsl:text>
    </xsl:template>

    <xsl:template match="members" mode="methods-header.text">
        <xsl:text>Методы</xsl:text>
    </xsl:template>

    <xsl:template match="static" mode="properties-header.text">
        <xsl:text>Статические поля</xsl:text>
    </xsl:template>

    <xsl:template match="static" mode="methods-header.text">
        <xsl:text>Статические методы</xsl:text>
    </xsl:template>

    <xsl:template match="property">
        <xsl:text>  * </xsl:text>
        <xsl:apply-templates select="@name"/>
        <xsl:apply-templates select="../.."/>
        <xsl:apply-templates select="@type"/>
        <xsl:apply-templates select="desc"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="method">
        <xsl:text>====</xsl:text>
        <xsl:apply-templates select="@name"/>
        <xsl:text>(</xsl:text>
        <xsl:apply-templates select="params/param" mode="method"/>
        <xsl:text>)</xsl:text>
        <xsl:apply-templates select="../.."/>
        <xsl:apply-templates select="deprecated"/>
        <xsl:apply-templates select="desc"/>
        <xsl:text>&#xA;</xsl:text>
        <xsl:apply-templates select="params/param"/>
    </xsl:template>

    <xsl:template match="param">
        <xsl:text>  * </xsl:text>
        <xsl:apply-templates select="@name"/>
        <xsl:apply-templates select="@type"/>
        <xsl:apply-templates select="desc"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="param" mode="method">
        <xsl:if test="position() &gt; 1">
            <xsl:text>, </xsl:text>
        </xsl:if>
        <xsl:if test="@optional">[</xsl:if>
        <xsl:value-of select="@name"/>
        <xsl:if test="@optional">]</xsl:if>
    </xsl:template>

    <xsl:template match="@name">
        <xsl:text>**</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>**</xsl:text>
    </xsl:template>

    <xsl:template match="method/@name">
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="@type">
        <xsl:text> ##{</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>}##</xsl:text>
    </xsl:template>

    <xsl:template match="deprecated">
        <xsl:text>&#xA;**deprecated** </xsl:text>
        <xsl:value-of select="wiki:encode(.)"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="desc">
        <xsl:text> </xsl:text>
        <xsl:value-of select="wiki:encode(.)"/>
    </xsl:template>

    <xsl:template match="class/desc | method/desc">
        <xsl:text>&#xA;</xsl:text>
        <xsl:value-of select="wiki:encode(.)"/>
    </xsl:template>

    <xsl:template match="public"/>

    <xsl:template match="protected | private">
        <xsl:value-of select="concat('^^##', local-name(), '##^^')"/>
    </xsl:template>

</xsl:stylesheet>
