function publish(symbolSet) {

    var files = {};
    symbolSet.toArray()
        .filter(function(symbol) {
            return symbol.is('CONSTRUCTOR') || symbol.isNamespace;
        })
        .forEach(function(symbol) {
            if(symbol.name == '_global_') {
                return;
            }

            var fileName = removeExt(getLocalFileName(symbol.srcFile)) + '.jsdoc.xml',
                fileDir = getDir(symbol.srcFile),
                fileKey = fileDir + fileName;

            files[fileKey] || (files[fileKey] = {
                name : fileName,
                dir : fileDir,
                content : []
            });

            files[fileKey].content.push(clsToXml(symbol));
        });

    var file;
    for(var key in files) {
        if(files.hasOwnProperty(key)) {
            file = files[key];
            IO.saveFile(file.dir, file.name, '<?xml version="1.0"?><jsdoc>' + file.content.join('') + '</jsdoc>');
        }
    }

}

function getDir(file) {

    return (file.indexOf('/') > -1? file.substr(0, file.lastIndexOf('/')) : '.') + '/';

}

function getLocalFileName(file) {

    return file.indexOf('/') > -1? file.substr(file.lastIndexOf('/') + 1) : file;

}

function removeExt(file) {

    return file.indexOf('.') > -1? file.substr(0, file.lastIndexOf('.')) : file;

}

/* фильтры */

function isStatic(method) {

    return method.isStatic;

}

function isNotStatic(method) {

    return !isStatic(method);

}

function isPrivate(method) {

    return method.isPrivate;

}

function isProtected(method) {

    return !!method.comment.getTag('protected')[0];

}

function isPublic(method) {

    return !isPrivate(method) && !isProtected(method);

}

function clsToXml(cls) {

    cls.methods = cls.getMethods();
    var obj = [
        ['public', 'protected', 'private'],
        [['properties', propertyToXml], ['methods', methodToXml]],
        [isPublic, isProtected, isPrivate]];
    return toTagXml(
            'class',
            toAttrXml(cls, 'name') + toAttrXml(cls, 'srcFile', 'src', getLocalFileName),
            toTagXml('desc', '', cls.classDesc) + [['members', isNotStatic], ['static', isStatic]].map(function(type) {
        return toTagXml(type[0], '',
            obj[0].map(function(level, i) {
                return toTagXml(level, '',
                    obj[1].map(function(desc) {
                        var props = cls[desc[0]].filter(type[1]);
                        return toTagXml(desc[0], '', props
                            .filter(obj[2][i])
                            .map(function(prop) {
                                return desc[1](prop);
                            }).join(''));
                    }).join(''));
                }).join(''));
    }).join(''));
}

function methodToXml(method) {

    return toTagXml('method', toAttrXml(method, 'name'),
        toTagXml('deprecated', '', method.comment.getTag('deprecated')[0]) +
        toTagXml('desc', '', method.desc) +
        toTagXml('params', '',
            method.params.map(function(param) {
                return paramToXml(param);
            }).join('')) +
        returnsToXml(method.returns));

}

function paramToXml(param) {

    return toTagXml(
        'param',
        toAttrXml(param, 'name') + toAttrXml(param, 'type') + toAttrXml(param, 'isOptional', 'optional') +
            toAttrXml(param, 'defaultValue', 'default'),
        toTagXml('desc', '', param.desc));

}

function returnsToXml(returns) {

    return returns.map(function(returns) {
        return toTagXml(
            'returns',
            toAttrXml(returns, 'type'),
            toTagXml('desc', '', returns.desc));
    });

}

function propertyToXml(property) {

    return toTagXml('property', toAttrXml(property, 'name') + toAttrXml(property, 'type'),
        toTagXml('desc', '', property.desc));

}

function toTagXml(tagName, attrs, content) {

    return content || attrs?
        '<' + tagName + attrs + (!content? '/' : '') + '>' + (content? content + '</' + tagName + '>' : '') :
        '';

}

function toAttrXml(obj, name, attrName, fn) {

    if(attrName && typeof attrName != 'string') {
        fn = attrName;
        attrName = null;
    }

    var val = typeof name == 'string'? (obj[name]) : name;
    fn && (val = fn(val));
    return val? ' ' + (attrName? attrName : name) + '="' + (val === true? 'yes' : val) + '"' : '';

}