BEM.decl('i-clipboard', {
    
    onSetMod: {
        'js': function() {
            var input = this.params.input;
            var button = this.params.button;
            var clipboard = BEM.blocks['i-clipboard__zeroclipboard'].get();

            clipboard.addEventListener('mousedown', function() {
                button.trigger('mousedown'); // Trigger original effect
                clipboard.setText(input.val().replace(/\r\n/g, '\n'));
            });

            clipboard.addEventListener('mouseup', function() {
                button.trigger('mouseup'); // Trigger original effect
                input[0].focus();
            });
            
            clipboard.addEventListener('mouseover', function() {
                clipboard.reposition(); // Trigger original effect
            });

            clipboard.setHandCursor(true);
            clipboard.glue(button.get(0));

            button.hover(function(){
              clipboard.reposition();
            });
        }
    }
});
