<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:math="http://exslt.org/math"
    exclude-result-prefixes=" x lego math "
    extension-element-prefixes=" math "
    version="1.0">

<!-- ############################################################################################################## -->

<!-- FIXME: убрать lego:class, никто не должен прописывать классы в raw.xml -->
<xsl:template match="*" mode="lego:attributes">
    <xsl:apply-templates select="." mode="lego:id"/>
    <xsl:apply-templates select="." mode="lego:class"/>
</xsl:template>

<xsl:template match="lego:link" mode="lego:attributes">
    <xsl:apply-templates select="." mode="lego:id"/>
    <xsl:apply-templates select="." mode="lego:class"/>
    <xsl:copy-of select="@target"/>
</xsl:template>

<xsl:template match="*" mode="lego:block-attributes">
    <xsl:apply-templates select="." mode="lego:block-class"/>
</xsl:template>

<xsl:template match="*" mode="lego:form-attributes">
    <xsl:apply-templates select="." mode="lego:action"/>
    <xsl:apply-templates select="." mode="lego:method"/>
    <xsl:apply-templates select="." mode="lego:onsubmit"/>
</xsl:template>

<xsl:template match="*" mode="lego:input-attributes">
    <xsl:apply-templates select="." mode="lego:id"/>
    <xsl:apply-templates select="." mode="lego:type"/>
    <xsl:apply-templates select="." mode="lego:name"/>
    <xsl:apply-templates select="." mode="lego:value"/>
    <xsl:apply-templates select="." mode="lego:size"/>
    <xsl:apply-templates select="." mode="lego:maxlength"/>
    <xsl:apply-templates select="." mode="lego:tabindex"/>
    <xsl:apply-templates select="." mode="lego:disabled"/>
    <xsl:apply-templates select="." mode="lego:readonly"/>
    <xsl:apply-templates select="." mode="lego:autocomplete"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:attribute-if-content">
<xsl:param name="name"/>
<xsl:param name="content"/>
   <xsl:if test="$content != ''">
        <xsl:attribute name="{$name}">
            <xsl:value-of select="$content"/>
        </xsl:attribute>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="* | @*" mode="lego:id">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'id'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:id-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="* | @*" mode="lego:id-content"/>

<xsl:template match="*[@id]" mode="lego:id-content">
    <xsl:value-of select="@id"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:auto-id">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'id'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:auto-id-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:auto-id-content">
    <xsl:value-of select="generate-id()"/>
</xsl:template>

<xsl:template match="lego:*[@id]" mode="lego:auto-id-content">
    <xsl:value-of select="@id"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="*" mode="lego:block-class">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'class'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:block-class-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="*" mode="lego:block-class-content">
    <xsl:variable name="name">
        <xsl:apply-templates select="." mode="lego:block-class-content-name"/>
    </xsl:variable>
    <xsl:variable name="class">
        <xsl:value-of select="$name"/>
        <xsl:for-each select="@*[namespace-uri() = 'https://lego.yandex-team.ru']">
            <xsl:value-of select="concat(' ', $name, '_')"/>
            <xsl:apply-templates select="." mode="lego:class-modifier"/>
        </xsl:for-each>
        <xsl:apply-templates select="." mode="lego:block-class-js"/>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="." mode="lego:block-class-mix"/>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="." mode="lego:class-content"/>
    </xsl:variable>
    <xsl:value-of select="normalize-space($class)"/>
</xsl:template>

<xsl:template match="*" mode="lego:block-class-content-name">
    <xsl:value-of select="lego:name(.)"/>
</xsl:template>

<xsl:template match="*" mode="lego:block-class-js"/>
<xsl:template match="lego:*[@lego:is-bem = 'yes']" mode="lego:block-class-js"> i-bem</xsl:template>

<xsl:template match="*" mode="lego:block-class-mix"/>

<xsl:template match="*[lego:mix]" mode="lego:block-class-mix">
    <xsl:for-each select="lego:mix/*">
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="." mode="lego:block-class-content"/>
    </xsl:for-each>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="* | @*" mode="lego:class">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'class'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:class-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="* | @*" mode="lego:class-content"/>

<xsl:template match="*[@class]" mode="lego:class-content">
    <xsl:value-of select="@class"/>
</xsl:template>

<xsl:template match="@*" mode="lego:class-modifier">
    <xsl:value-of select="local-name()"/>
</xsl:template>

<xsl:template match="@*[. != '']" mode="lego:class-modifier">
    <xsl:value-of select="concat(local-name(), '_', .)"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="* | @*" mode="lego:url">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'href'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:url-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="* | @*" mode="lego:url-content"/>

<xsl:template match="*[@url]" mode="lego:url-content">
    <xsl:value-of select="@url"/>
</xsl:template>

<!-- ############################################################################################################## -->

<!-- You're lucky! -->
<xsl:variable name="lego:show-counters">
    <xsl:apply-templates select="/" mode="lego:show-counters"/>
</xsl:variable>

<xsl:template match="/" mode="lego:show-counters">
    <xsl:copy-of select="floor(math:random() * 10) = 7"/>
</xsl:template>

<xsl:template match="lego:*" mode="lego:counter">
    <xsl:param name="show-counter" select="$lego:show-counters != 'false'"/>
    <xsl:if test="$show-counter">
        <xsl:variable name="counter">
            <xsl:apply-templates select="." mode="lego:counter-content"/>
        </xsl:variable>
        <xsl:if test="$counter != ''">
            <xsl:variable name="event">
                <xsl:apply-templates select="." mode="lego:counter-event"/>
            </xsl:variable>
            <xsl:attribute name="{$event}">
                <xsl:text>Lego.ch(</xsl:text>
                <xsl:value-of select="x:js-quote($counter)"/>
                <xsl:text>,this)</xsl:text>
            </xsl:attribute>
        </xsl:if>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:*" mode="lego:counter-content">
    <xsl:value-of select="@counter"/>
</xsl:template>

<xsl:template match="lego:*" mode="lego:counter-event">
    <xsl:text>onmousedown</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:onclick">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'onclick'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:onclick-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:onclick-content"/>

<xsl:template match="lego:*[@onclick]" mode="lego:onclick-content">
    <xsl:value-of select="@onclick"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:action">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'action'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:action-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:action-content"/>

<xsl:template match="lego:*[@action]" mode="lego:action-content">
    <xsl:value-of select="@action"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:method">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'method'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:method-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:method-content"/>

<xsl:template match="lego:*[@method]" mode="lego:method-content">
    <xsl:value-of select="@method"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:onsubmit">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'onsubmit'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:onsubmit-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:onsubmit-content"/>

<xsl:template match="lego:*[@onsubmit]" mode="lego:onsubmit-content">
    <xsl:value-of select="@onsubmit"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:type">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'type'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:type-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:type-content"/>

<xsl:template match="lego:*[@type]" mode="lego:type-content">
    <xsl:value-of select="@type"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:name">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'name'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:name-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:name-content"/>

<xsl:template match="lego:*[@name]" mode="lego:name-content">
    <xsl:value-of select="@name"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:value">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'value'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:value-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:value-content"/>

<xsl:template match="lego:*[@value]" mode="lego:value-content">
    <xsl:value-of select="@value"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:size">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'size'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:size-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:size-content"/>

<xsl:template match="lego:*[@size]" mode="lego:size-content">
    <xsl:value-of select="@size"/>
</xsl:template>

<xsl:template match="lego:*" mode="lego:autocomplete">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'autocomplete'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:autocomplete-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:autocomplete-content"/>

<xsl:template match="lego:*[@autocomplete]" mode="lego:autocomplete-content">
    <xsl:value-of select="@autocomplete"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:maxlength">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'maxlength'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:maxlength-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:maxlength-content"/>

<xsl:template match="lego:*[@maxlength]" mode="lego:maxlength-content">
    <xsl:value-of select="@maxlength"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:tabindex">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'tabindex'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:tabindex-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:tabindex-content"/>

<xsl:template match="lego:*[@tabindex]" mode="lego:tabindex-content">
    <xsl:value-of select="@tabindex"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:disabled">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'disabled'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:disabled-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:disabled-content"/>

<xsl:template match="lego:*[@disabled]" mode="lego:disabled-content">
    <xsl:value-of select="@disabled"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:readonly">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'readonly'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:readonly-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:readonly-content"/>

<xsl:template match="lego:*[@readonly]" mode="lego:readonly-content">
    <xsl:value-of select="@readonly"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:src">
    <xsl:call-template name="lego:attribute-if-content">
        <xsl:with-param name="name" select="'src'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:src-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:*" mode="lego:src-content"/>

<xsl:template match="lego:*[@src]" mode="lego:src-content">
    <xsl:value-of select="@src"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:alt">
    <xsl:attribute name="alt">
        <xsl:apply-templates select="." mode="lego:alt-content"/>
    </xsl:attribute>
</xsl:template>

<xsl:template match="lego:*" mode="lego:alt-content"/>

<xsl:template match="lego:*[@alt]" mode="lego:alt-content">
    <xsl:value-of select="@alt"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:content">
    <xsl:apply-templates/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:*" mode="lego:js-params">
    <xsl:variable name="mix">
        <xsl:apply-templates select="." mode="lego:js-params-mix"/>
    </xsl:variable>
    <xsl:variable name="is-bem" select="@lego:is-bem or contains(local-name(), '-bem-') or self::lego:b-act-item or self::lego:b-subscriptions"/>
    <xsl:variable name="js-params-content">
        <!-- NOTE Костыль для i-bem блоков -->
        <xsl:value-of select="$mix"/>
        <xsl:if test="$is-bem"><xsl:value-of select="x:js-quote(lego:name(.))"/>:{</xsl:if>
        <xsl:apply-templates select="." mode="lego:js-params-content"/>
        <xsl:if test="$is-bem">}</xsl:if>
    </xsl:variable>
    <xsl:if test="boolean(normalize-space($js-params-content))">
        <xsl:attribute name="onclick">
            <xsl:text>return {</xsl:text>
                <xsl:value-of select="$js-params-content"/>
            <xsl:text>}</xsl:text>
        </xsl:attribute>
    </xsl:if>
</xsl:template>

<!-- NOTE Костыль для смешивания блоков на одной дом-ноде -->
<xsl:template match="lego:*" mode="lego:js-params-mix"/>

<xsl:template match="lego:*[lego:mix]" mode="lego:js-params-mix">
    <xsl:variable name="current" select="."/>
    <xsl:for-each select="lego:mix/*[lego:is-block(.)]">
        <xsl:variable name="has-js">
            <xsl:apply-templates select="." mode="lego:block-class-js"/>
        </xsl:variable>
        <xsl:if test="string($has-js)">
            <xsl:value-of select="x:js-quote(lego:name(.))"/>
            <xsl:text>:{</xsl:text>
                <xsl:apply-templates select="." mode="lego:js-params-content"/>
            <xsl:text>},</xsl:text>
        </xsl:if>
    </xsl:for-each>
</xsl:template>

<!-- <xsl:template match="lego:*" mode="lego:js-params-content"/> -->

<xsl:template match="lego:*" mode="lego:js-params-content">
    <xsl:text>name:</xsl:text><xsl:value-of select="x:js-quote(lego:name(.))"/>
</xsl:template>

<xsl:template match="lego:*[contains(local-name(), '-bem-')]" mode="lego:js-params-content">
    <xsl:text>bla:1</xsl:text>
</xsl:template>

<xsl:template match="lego:*/@*" mode="lego:js-params-content">
    <xsl:param name="need-comma" select="boolean(position() - 1)"/>
    <xsl:if test="$need-comma">,</xsl:if>
    <xsl:value-of select="concat(name(), ':', x:js-quote(.))"/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

