/**
 * Плагин для декодирования URI-escaped строки в кодировке CP1251
 *
 * Copyright (c) 2011 Roman Rozhdestvenskiy (sbmaxx@gmail.com)
 */
(function($) {

function convertEncodings(str) {
    // таблица соответствия cp1251 и utf8.
    // код символа в cp1251 (hex) : код символа в utf8 (hex)
    var map = { "%D0": "%D0%A0","%C0": "%D0%90","%C1": "%D0%91","%C2": "%D0%92","%C3": "%D0%93","%C4": "%D0%94","%C5": "%D0%95","%A8": "%D0%81","%C6": "%D0%96","%C7": "%D0%97","%C8": "%D0%98","%C9": "%D0%99","%CA": "%D0%9A","%CB": "%D0%9B","%CC": "%D0%9C","%CD": "%D0%9D","%CE": "%D0%9E","%CF": "%D0%9F","%D1": "%D0%A1","%D2": "%D0%A2","%D3": "%D0%A3","%D4": "%D0%A4","%D5": "%D0%A5","%D6": "%D0%A6","%D7": "%D0%A7","%D8": "%D0%A8","%D9": "%D0%A9","%DA": "%D0%AA","%DB": "%D0%AB","%DC": "%D0%AC","%DD": "%D0%AD","%DE": "%D0%AE","%DF": "%D0%AF","%E0": "%D0%B0","%E1": "%D0%B1","%E2": "%D0%B2","%E3": "%D0%B3","%E4": "%D0%B4","%E5": "%D0%B5","%B8": "%D1%91","%E6": "%D0%B6","%E7": "%D0%B7","%E8": "%D0%B8","%E9": "%D0%B9","%EA": "%D0%BA","%EB": "%D0%BB","%EC": "%D0%BC","%ED": "%D0%BD","%EE": "%D0%BE","%EF": "%D0%BF","%F0": "%D1%80","%F1": "%D1%81","%F2": "%D1%82","%F3": "%D1%83","%F4": "%D1%84","%F5": "%D1%85","%F6": "%D1%86","%F7": "%D1%87","%F8": "%D1%88","%F9": "%D1%89","%FA": "%D1%8A","%FB": "%D1%8B","%FC": "%D1%8C","%FD": "%D1%8D","%FE": "%D1%8E","%FF": "%D1%8F" };
    str = str.toUpperCase().replace(/%.{2}/g, function($0) { return map[$0] });
    return str;
}

$.extend({
    decodeURIComponent : function(str) {
        var decoded = '';
        // блок try/catch для определения кодировки исходной строки
        // ошибка выбрасывается в случае подачи на входе не UTF8 строки
        // если строка была не декодирована, то она возвращается без изменений
        try {
            decoded = decodeURIComponent(str);
        } catch (e) {
            decoded = decodeURIComponent(convertEncodings(str));
        }
        return decoded;
    }
});

})(jQuery);
