var os = require('os'),
    fs = require('file'),
    Tech = require('bem/lib/tech').Tech;

exports.techModule = module;

exports.bemBuild = function (prefixes, outputDir, outputName) {
    var tmpName = '.tmp.' + outputName;

    ['css', 'js'].forEach(function(t){
        (new Tech('../../tools/bem/techs/' + t + '.js'))
            .bemBuild(prefixes, outputDir, tmpName);
    });

    os.command('ycssjs --once=yes ' + tmpName + '.*');

    ['', '.ie'].forEach(function(suffix){
        outputDir.join(outputName + '.bembundle' + suffix + '.js')
            .write([
                "BEM.blocks['i-loader'].loaded({",
                "id:'", outputName, "',\n",
                "js:function(){", fs.read('_' + tmpName + '.js'), '},\n',
                "css:", JSON.encode(fs.read('_' + tmpName + suffix + '.css')), "\n",
                "});"].join(''));
    });

    tmpName += '.*';
    os.command(['rm', tmpName, '_' + tmpName].join(' '));

    return this;
};
