var Q = require('q'),
    exec = require('child_process').exec,
    fs = require('fs'),
    myPath = require('bem/lib/path'),
    Tech = require('bem/lib/legacy-tech').Tech;

exports.techModule = module;

exports.bemBuild = function (prefixes, outputDir, outputName) {

    var defer = Q.defer(),
    	_this = this,
        tmpName = '.tmp.' + outputName;

    ['css', 'js'].forEach(function(t){
        (new Tech(myPath.join(__dirname, '../../../../../tools/bem/techs/nodejs/' + t + '.js')))
            .bemBuild(prefixes, outputDir, tmpName);
    });

    exec('ycssjs --once=yes ' + outputDir + '/' + tmpName + '.*', function(err, stdout, stderr) {
        if (err) return defer.reject(err);

        ['', '.ie'].forEach(function(suffix){
            var filename = myPath.join(
                  outputDir,
                  outputName + '.bembundle' + suffix + '.js'
                ),
                content = [
                  "BEM.blocks['i-loader'].loaded({",
                  "id:'", outputName, "',\n",
                  "js:function(){",
                      _this.bemBuildContentJs(outputDir, outputName),
                  '},\n',
                  "css:", JSON.stringify(fs.readFileSync(outputDir + '/_' + tmpName + suffix + '.css', 'utf-8')), "\n",
                  "});"
                ].join('');

            fs.writeFileSync(filename, content);
        });

        tmpName += '.*';
        exec(['rm', outputDir + tmpName, outputDir + '_' + tmpName].join(' '), function(err, stdout, stderr) {
	        if (err) return defer.reject(err);
        	defer.resolve();
        });
    });

    return defer.promise;
};

exports.bemBuildContentJs = function (outputDir, outputName) {
    return fs.readFileSync(outputDir + '/_.tmp.' + outputName + '.js', 'utf-8');
};
