(function($) {

var head,
    bundles = {},
    loader =

BEM.decl('i-loader', {}, {

    /**
     * Загружает бандл
     * @param {String} bundleId идентификатор бандла
     * @param {String} bundlePath путь бандла
     * @param {Function} onSuccess callback-функция на успешную загрузку
     * @param {Function} [onError] callback-функция на неуспешную загрузку
     */
    load : function(bundleId, bundlePath, onSuccess, onError) {

        if(typeof bundlePath != 'string') {
            onError = onSuccess;
            onSuccess = bundlePath;
            bundlePath = bundleId;
        }

        var bundle = bundles[bundleId];
        if(bundle) {
            if(bundle.successFns[0]) { // значит идет загрузка бандла
                bundle.successFns.push(onSuccess);
                onError && bundle.errorFns.push(onError);
            } else if(bundle.error) { // была ошибка при загрузке
                onError && onError();
            } else { // бандл уже был загружен
                this.afterCurrentEvent(onSuccess);
            }
            return;
        }

        var doc = document,
            script = doc.createElement('script'),
            errorFn = function() { loader._error(bundleId) };

        script.type = 'text/javascript';
        script.charset = 'utf-8';
        script.src = !$.browser.msie || doc.documentMode > 8? bundlePath : bundlePath.replace(/(\.[^.]+)$/, '.ie$1');
        script.onerror = errorFn; // для тех браузеров, кто поддерживает
        setTimeout(function() {
            (head || (head = $('head')[0])).insertBefore(script, head.firstChild);
        }, 0);

        bundles[bundleId] = {
            successFns : [onSuccess],
            errorFns : onError? [onError] : [],
            timer : setTimeout(errorFn, 20000)
        };

    },

    loaded : function(bundle) {

        var bundleDesc = bundles[bundle.id];

        clearTimeout(bundleDesc.timer);

        bundle.js && bundle.js();
        bundle.css && $('head').append('<style type="text/css">' + bundle.css + '</style>');

        var fns = bundleDesc.successFns, fn;
        while(fn = fns.shift()) fn();

    },

    _error : function(bundleId) {

        var bundleDesc = bundles[bundleId],
            fns = bundleDesc.errorFns, fn;

        bundleDesc.error = true;
        while(fn = fns.shift()) fn();

    }

});

})(jQuery);