(function($) {

var cache = {};

BEM.decl('i-request', {

    get : function(request, onSuccess, onError, params) {

        if(!$.isFunction(onError)) {
            params = onError;
            onError = this.params.onError;
        }

        this._get(request, onSuccess, onError, $.extend({}, this.params, params));

    },

    _get : function(request, onSuccess, onError, params) {

        var _this = this,
            args = arguments,
            key = _this._buildCacheKey(request, params);

        _this.afterCurrentEvent(function() {
            var cacheGroup = cache[params.cacheGroup];
            params.cache && cacheGroup && key in cacheGroup.data?
                onSuccess.call(_this.params.callbackCtx, cacheGroup.data[key]) :
                _this._do.apply(_this, args);
        });

    },

    _do : function(request, onSuccess, onError, params) {},

    _onSuccess : function(requestKey, request, data, params) {

        params.cache && this.putToCache(params, requestKey, data);

    },

    _buildCacheKey : function(obj, params) {

        return typeof obj == 'string'?
           obj :
           $.param(obj);

    },

    putToCache : function(params, request, data) {

        var cacheGroup = cache[params.cacheGroup] || (cache[params.cacheGroup] = { keys : [], data : {}});

        if(cacheGroup.keys.length >= params.cacheSize) {
            delete cacheGroup.data[cacheGroup.keys.shift()];
        }

        var key = this._buildCacheKey(request, params);

        cacheGroup.data[key] = data;
        cacheGroup.keys.push(key);

    },

    dropCache : function() {

        delete cache[this.params.cacheGroup];

    },

    getDefaultParams : function() {

        return {
            cache : false,
            cacheGroup : 'default',
            cacheSize : 100,
            callbackCtx : this
        };

    }

});

})(jQuery);