(function($) {
window.Lego || (window.Lego = {block: {}});

Lego.block['i-social'] = function(params) {

    function Broker(params) {
        var that = this,
            handlers = {};

        this.url = params.startUrl + '?';
        delete params.startUrl;
        this.popupName = params.popupName;
        this.yaWindow = null;
        this.wTimer = null;
        this.paramsDefault = params;

        function isClosed() {
            var closed;
            if (!that.yaWindow) return true;
            try {
                closed = that.yaWindow.closed;
            } catch (e) {
                closed = true;
            }
            return closed;
        }

        function windowWatcher() {
            if (isClosed()) {
                that.wTimer = clearInterval(that.wTimer);
                that.onFailure({status: 'error'});
            }
        }

        function openPopup(paramsOverride) {
            var popupName = that.popupName,
                width = 500,
                height = 280,
                left = Math.round (((window.opera ? window.innerWidth : screen.availWidth) - width) / 2),
                top = Math.round (((window.opera ? window.innerHeight : screen.availHeight) - height) / 2),
                popupParams = 'scrollbars=yes, resizable=1, menubar=0, toolbar=0, status=0, location=0, directories=0' + ', left=' + left + ', top=' + top + ', width=' + width + ', height=' + height;

            var myP = {};

            for (var i in that.paramsDefault) {
                myP[i] = that.paramsDefault[i];
            }

            for (var i in paramsOverride) {
                myP[i] = paramsOverride[i];
            }

            if (myP['display'] && myP['display'] != 'popup'){
                myP.retpath = myP.retnopopup || window.location.href;
            } else {
                var cbParams = 'ddom=' + (myP.ddom || (location.hostname == document.domain ? '' : document.domain));
                if ('retnopopup' in myP) {
                    delete myP.retnopopup;
                }
                myP.retpath += (myP.retpath.match('#') ? '&' : '#') + cbParams;
            }
            var url = that.url;

            var p = [];
            for (var j in myP) {
               p.push(encodeURIComponent(j) + '=' + encodeURIComponent(myP[j]));
            }
            url += p.join('&');

            if (myP['display'] && myP['display'] != 'popup'){
                window.location.href = url;
                return;
            }

            that.yaWindow = window.open(url, popupName, popupParams);
            that.yaWindow.focus();

            if (that.yaWindow) {
                that.wTimer = setInterval(windowWatcher, 500);
            }
        }

        function cleanup() {
            this.handlers = {onSuccess: null, onFailure: null};
            that.wTimer = clearInterval(that.wTimer);
            isClosed() || that.yaWindow.close();
            that.yaWindow = false;
        }

        this.start = function(onSuccess, onFailure, paramsOverride) {
            cleanup();
            that.handlers = {onSuccess: onSuccess, onFailure: onFailure};
            openPopup(paramsOverride);
        };

        this.onSuccess = function(data) {
            cleanup();
            var f = that.handlers.onSuccess;
            f && f();
        };

        this.onFailure = function(data) {
            cleanup();
            var f = that.handlers.onFailure;
            f && f();
        };
    }

    arguments.callee.Broker = Broker;

    var defaultParams = arguments.callee.defaultParams = {
        startUrl: Lego.params['social-startUrl'] || Lego.params['social-host'] + '/broker/start',
        retpath: Lego.params['social-retpath'] || location.protocol + '//' + location.host + Lego.params['lego-path'] + '/blocks/i-social/closer/i-social__closer.html',
        retnopopup: Lego.params['social-retnopopup'] || false,
        consumer: Lego.params.id || 'morda',
        popupName: 'social_' + (Lego.params.id || 'morda'),
        application: '',
        action_if_anonymous: 'authorize',
        result_location: 'fragment'
    };

    var broker = arguments.callee.broker = new Broker($.extend(defaultParams, params));
    return broker;

};
})(jQuery);
