<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:func="http://exslt.org/functions"
    xmlns:exsl="http://exslt.org/common"
    xmlns:str="http://exslt.org/strings"
    extension-element-prefixes="func exsl"
    exclude-result-prefixes=" lego x func exsl str"
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="/" mode="lego:default-params">
    <xsl:apply-imports/>
    <lego:current-url>
        <lego:protocol>http://</lego:protocol>
        <lego:host><xsl:value-of select="x:get-protocol-arg('host')"/></lego:host>
        <lego:path>
            <xsl:variable name="originaluri">
                <xsl:value-of select="x:get-protocol-arg('originaluri')"/>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="contains($originaluri, '?')">
                    <xsl:value-of select="substring-before($originaluri, '?')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$originaluri"/>
                </xsl:otherwise>
            </xsl:choose>
        </lego:path>
        <lego:params><xsl:apply-templates select="x:mist('set_state_by_request', '')/param[@name]"/></lego:params>
    </lego:current-url>
</xsl:template>

<!-- ############################################################################################################## -->
<xsl:template match="lego:i-url">
    <xsl:variable name="lego:i-url_normalized">
        <lego:i-url>
            <xsl:variable name="tmp-url" select="."/>
            <xsl:for-each select="$lego:params/lego:current-url/node()">
                <xsl:variable name="tmp-name" select="name()"/>
                <xsl:apply-templates select="." mode="lego:url-normalize">
                    <xsl:with-param name="custom-settings" select="$tmp-url/node()[name() = $tmp-name]"/>
                </xsl:apply-templates>
            </xsl:for-each>
            <xsl:call-template name="lego:anchor">
                <xsl:with-param name="custom-settings" select="lego:anchor"/>
            </xsl:call-template>
        </lego:i-url>
    </xsl:variable>

    <xsl:apply-templates select="exsl:node-set($lego:i-url_normalized)/lego:i-url/lego:protocol"/>
    <xsl:apply-templates select="exsl:node-set($lego:i-url_normalized)/lego:i-url/lego:host"/>
    <xsl:apply-templates select="exsl:node-set($lego:i-url_normalized)/lego:i-url/lego:path"/>
    <xsl:apply-templates select="exsl:node-set($lego:i-url_normalized)/lego:i-url/lego:params"/>
    <xsl:apply-templates select="exsl:node-set($lego:i-url_normalized)/lego:i-url/lego:anchor"/>

</xsl:template>

<!-- Нормализация параметров -->

<xsl:template match="lego:current-url/node()" mode="lego:url-normalize">
    <xsl:param name="custom-settings"/>
    <xsl:copy-of select="$custom-settings | current()[boolean($custom-settings) = false()]"/>
</xsl:template>

<xsl:template match="lego:current-url/lego:protocol" mode="lego:url-normalize">
    <xsl:param name="custom-settings"/>
    <lego:protocol>
        <xsl:choose>
            <xsl:when test="lego:ends-with($custom-settings, '://')">
                <xsl:value-of select="$custom-settings"/>
            </xsl:when>
            <xsl:when test="$custom-settings">
                <xsl:value-of select="$custom-settings"/>
                <xsl:text>://</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </lego:protocol>
</xsl:template>

<xsl:template match="lego:current-url/lego:path" mode="lego:url-normalize">
    <xsl:param name="custom-settings"/>
    <lego:path>
        <xsl:choose>
            <xsl:when test="starts-with($custom-settings, '/')">
                <xsl:value-of select="$custom-settings"/>
            </xsl:when>
            <xsl:when test="$custom-settings">
                <xsl:text>/</xsl:text>
                <xsl:value-of select="$custom-settings"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </lego:path>
</xsl:template>

<xsl:template match="lego:current-url/lego:params" mode="lego:url-normalize">
    <xsl:param name="custom-settings"/>

    <xsl:variable name="lego:custom-params_normalized">
        <xsl:choose>
            <xsl:when test="not(exsl:node-set($custom-settings)/lego:param)">
                <xsl:call-template name="lego:url-params-string2xml">
                    <xsl:with-param name="params" select="$custom-settings"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="exsl:node-set($custom-settings)/lego:param"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="lego:params_mixed">
        <xsl:copy-of select="lego:param[not(exsl:node-set($custom-settings)/@rewrite-params = 'true')]"/>
        <xsl:copy-of select="exsl:node-set($lego:custom-params_normalized)/lego:param"/>
    </xsl:variable>

    <xsl:variable name="lego:params_normalized">
        <xsl:copy-of select="exsl:node-set($lego:params_mixed)/node()[not(@name = preceding-sibling::lego:param/@name) or @duplicate-param = 'true']"/>
    </xsl:variable>

    <lego:params>
        <xsl:copy-of select="exsl:node-set($lego:params_normalized)/lego:param"/>
    </lego:params>
</xsl:template>

<xsl:template name="lego:anchor">
    <xsl:param name="custom-settings" select="''"/>
    <lego:anchor>
        <xsl:choose>
            <xsl:when test="starts-with($custom-settings, '#')">
                <xsl:value-of select="substring-after($custom-settings,'#')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$custom-settings"/>
            </xsl:otherwise>
        </xsl:choose>
    </lego:anchor>
</xsl:template>

<!-- /Нормализация параметров -->

<xsl:template match="lego:params">
    <xsl:if test="position() = 1">?</xsl:if>
    <xsl:apply-templates select="lego:param"/>
</xsl:template>

<xsl:template match="lego:params/lego:param">
    <xsl:if test="position() != 1">&amp;</xsl:if>
    <xsl:value-of select="@name"/>
    <xsl:text>=</xsl:text>
    <xsl:value-of select="x:urlencode(.)"/>
</xsl:template>

<xsl:template match="lego:i-url/lego:anchor">
    <xsl:if test=". != ''">#</xsl:if>
    <xsl:value-of select="."/>
</xsl:template>

<xsl:template name="lego:url-params-string2xml">
    <xsl:param name="params"/>

    <xsl:for-each select="str:tokenize($params, '&amp;')">
        <lego:param name="{substring-before(., '=')}">
            <xsl:value-of select="substring-after(., '=')"/>
        </lego:param>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
