<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    externsion-element-prefixes=" exsl x "
    exclude-result-prefixes=" x lego "
    version="1.0">

    <!-- Загружать по адресу http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&xxx=yyy -->

    <!-- ############################################################################################################## -->
    <xsl:import href="../../../tools/eval/eval.xsl"/>

    <xsl:template match="/">
        <html>
            <head>
                <title>i-url tests</title>
            </head>
            <body>
                
                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Текущий URL'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url/>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомный протокол'"/>
                    <xsl:with-param name="original-url" select="'ftp://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:protocol>ftp://</lego:protocol>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомный протокол без слешей'"/>
                    <xsl:with-param name="original-url" select="'ftp://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:protocol>ftp</lego:protocol>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомный домен'"/>
                    <xsl:with-param name="original-url" select="'http://blah-blah.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:host>blah-blah.yandex-team.ru</lego:host>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомный путь'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/foo/bar/?foo=bar&amp;xxx=yyy'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:path>/foo/bar/</lego:path>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомный путь без первого слеша'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/foo/bar/?foo=bar&amp;xxx=yyy'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:path>foo/bar/</lego:path>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомныe параметры'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy&amp;param1=value1&amp;param2=value2'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:params>
                                <lego:param name="param1">value1</lego:param>
                                <lego:param name="param2">value2</lego:param>
                            </lego:params>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомныe параметры, пересекающиеся с текущими'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy&amp;param1=value1'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:params>
                                <lego:param name="param1">value1</lego:param>
                                <lego:param name="foo">bar</lego:param>
                            </lego:params>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомныe параметры, передаваемые строкой'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy&amp;param1=value1&amp;param2=value2'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:params>param1=value1&amp;param2=value2</lego:params>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Кастомныe параметры, передаваемые строкой, c пересечением'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy&amp;param1=value1'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:params>param1=value1&amp;foo=bar</lego:params>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Дублирующийся кастомный параметр'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy&amp;param1=value1&amp;foo=bar2'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:params>
                                <lego:param name="param1">value1</lego:param>
                                <lego:param name="foo" duplicate-param="true">bar2</lego:param>
                            </lego:params>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Полная перезапись параметров'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?param1=value1&amp;param2=value2'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:params rewrite-params="true">
                                <lego:param name="param1">value1</lego:param>
                                <lego:param name="param2">value2</lego:param>
                            </lego:params>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Якорь'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy#anchor'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:anchor>anchor</lego:anchor>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="u-test">
                    <xsl:with-param name="title" select="'Якорь с решеткой'"/>
                    <xsl:with-param name="original-url" select="'http://toivonen-2-3.lego.veged.dev.yandex-team.ru/blocks/i-url/examples/u-tests.xml?foo=bar&amp;xxx=yyy#anchor'"/>
                    <xsl:with-param name="xml">
                        <lego:i-url>
                            <lego:anchor>#anchor</lego:anchor>
                        </lego:i-url>
                    </xsl:with-param>
                </xsl:call-template>

            </body>
        </html>
    </xsl:template>

    <xsl:template name="u-test">
        <xsl:param name="title"/>
        <xsl:param name="original-url"/>
        <xsl:param name="xml"/>

        <xsl:variable name="result">
            <xsl:call-template name="lego:apply">
                <xsl:with-param name="content" select="$xml"/>
            </xsl:call-template>
        </xsl:variable>

        <h3><xsl:value-of select="$title"/></h3>

        <xsl:if test="$original-url = $result">
            <p><xsl:value-of select="$original-url"/>
            <br/>
            <span style="background-color: green">Тест пройден</span>
            <br/>
            <xsl:value-of select="$result"/>
            </p>
        </xsl:if>
        <xsl:if test="$original-url != $result">
            <p><xsl:value-of select="$original-url"/>
            <br/>
            <span style="background-color: red">Тест провалился</span>
            <br/>
            <xsl:value-of select="$result"/>
            </p>
        </xsl:if>

    </xsl:template>

</xsl:stylesheet>
