<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    exclude-result-prefixes=" x lego exsl "
    extension-element-prefixes = " x exsl "
    version="1.0">

<xsl:template match="lego:i-user-agent/lego:mobile" mode="lego:params-param">
    <xsl:text>'mobile': {</xsl:text>
        <xsl:apply-templates select="@*" mode="lego:params-param"/>
        <xsl:apply-templates select="attr" mode="lego:params-param"/>
    <xsl:text>}</xsl:text>
</xsl:template>

<xsl:template match="lego:i-user-agent/lego:mobile/@*" mode="lego:params-param">
    <xsl:if test="position() != 1">,</xsl:if>
    <xsl:value-of select="x:js-quote(local-name())"/>
    <xsl:text>:</xsl:text>
    <xsl:value-of select="x:js-quote(.)"/>
</xsl:template>

<xsl:template match="lego:i-user-agent/lego:mobile/attr" mode="lego:params-param">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="x:js-quote(@name)"/>
    <xsl:text>:</xsl:text>
    <xsl:value-of select="x:js-quote(@value)"/>
</xsl:template>

<xsl:template match="model" mode="lego:mobile-block">
    <lego:i-user-agent>
        <lego:mobile>
            <xsl:copy-of select="@name | @vendor"/>
            <xsl:apply-templates select="attr" mode="lego:mobile-block"/>
        </lego:mobile>
    </lego:i-user-agent>
</xsl:template>

<xsl:template match="/" mode="lego:default-params-user-agent">
    <xsl:if test="lego:page/lego:i-user-agent/lego:mobile">
        <xsl:apply-imports/>
        <xsl:if test="not($lego:user-params/lego:i-user-agent/lego:mobile)">
            <xsl:variable name="result-xscript">
                <x:mobile-block>
                    <x:method>detect_phone</x:method>
                </x:mobile-block>
            </xsl:variable>
            <xsl:apply-templates select="exsl:node-set($result-xscript)" mode="lego:mobile-block"/>
        </xsl:if>
    </xsl:if>
</xsl:template>

<xsl:template match="model" mode="lego:mobile-block">
    <lego:mobile>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates select="attr" mode="lego:mobile-block"/>
    </lego:mobile>
</xsl:template>

<xsl:template match="model/attr" mode="lego:mobile-block"/>
<xsl:template match="model/attr[
    @name = 'device_class'
    or
    @name = 'screenx'
    or
    @name = 'screeny'
    ]" mode="lego:mobile-block">
    <xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>
