<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:l-head">
    <xsl:apply-templates select="lego:b-statcounter"/>
    <xsl:apply-templates select="lego:i-metrika"/>
    <xsl:apply-templates select="lego:i-flashcookie"/>
    <table>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </table>
</xsl:template>

<xsl:template match="lego:l-head" mode="lego:content">
    <tr>
        <td class="l-head__g"><i class="l-head__gap"></i></td>
        <td class="l-head__l">
            <xsl:apply-templates select="lego:b-head-logo"/>
        </td>
        <td class="l-head__gl"><i class="l-head__gap"></i></td>
        <td class="l-head__c">
            <xsl:apply-templates select="." mode="lego:l-head__c-content"/>
        </td>
        <td class="l-head__gr"><i class="l-head__gap"></i></td>
        <td class="l-head__r">
            <xsl:apply-templates select="lego:b-head-userinfo"/>
        </td>
        <td class="l-head__g"><i class="l-head__gap"></i></td>
    </tr>
</xsl:template>

<xsl:template match="lego:l-head" mode="lego:l-head__c-content">
    <xsl:apply-templates select="lego:b-head-tabs"/>
    <xsl:apply-templates select="lego:b-head-search | lego:b-head-line | lego:b-head-toolbar | lego:b-toolbar"/>
    <xsl:apply-templates select="lego:b-head-menu"/>
    <xsl:text> </xsl:text><!-- Fix for LEGO-45: При изменении размеров окна ссылка "ещё" налезает на другие ссылки и иногда исчезает (фф 3.0.1 под MacOS) -->
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

