<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:l-page">
    <table>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:l-page"/>
    </table>
</xsl:template>

<xsl:template match="lego:l-page | lego:row" mode="lego:l-page">
    <tr>
        <xsl:apply-templates select="lego:gap | lego:gap-left | lego:gap-right | lego:left | lego:center | lego:right" mode="lego:l-page"/>
    </tr>
</xsl:template>

<xsl:template match="lego:l-page[lego:row]" mode="lego:l-page">
    <xsl:apply-templates select="lego:row" mode="lego:l-page"/>
</xsl:template>

<xsl:template match="lego:gap | lego:gap-left | lego:gap-right" mode="lego:l-page">
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <i></i>
    </td>
</xsl:template>

<xsl:template match="lego:left | lego:center | lego:right" mode="lego:l-page">
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </td>
</xsl:template>

<xsl:template match="lego:gap | lego:gap-left | lego:gap-right | lego:left | lego:center | lego:right" mode="lego:block-attributes">
    <xsl:copy-of select="@colspan | @rowspan"/>
    <xsl:apply-imports/>
</xsl:template>

<xsl:template match="lego:l-page//lego:left-i | lego:l-page//lego:center-i | lego:l-page//lego:right-i">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>
